/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.inject.injecto.internal;

import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.mapper.Mapper;
import hudson.XmlFile;
import hudson.model.Hudson;
import hudson.model.Items;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.UpdateCenter;
import hudson.util.RobustReflectionConverter;
import javax.inject.Inject;
import javax.inject.Named;
import org.hudsonci.inject.injecto.Injectomatic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.inject.EagerSingleton;

@Named
@EagerSingleton
public class XStreamInjectoHandler {
    private static final Logger log = LoggerFactory.getLogger(XStreamInjectoHandler.class);
    private static final XStream[] DEFAULT_XSTREAMS = new XStream[]{Hudson.XSTREAM, Items.XSTREAM, Queue.XSTREAM, Run.XSTREAM, UpdateCenter.XSTREAM, XmlFile.DEFAULT_XSTREAM};
    private final Injectomatic injecto;
    private final ReflectionProvider reflection;

    @Inject
    public XStreamInjectoHandler(Injectomatic injecto, ReflectionProvider reflection) {
        this.injecto = (Injectomatic)Preconditions.checkNotNull((Object)injecto);
        this.reflection = (ReflectionProvider)Preconditions.checkNotNull((Object)reflection);
        XStream[] xStreamArray = DEFAULT_XSTREAMS;
        int n = DEFAULT_XSTREAMS.length;
        int n2 = 0;
        while (n2 < n) {
            XStream xs = xStreamArray[n2];
            this.register(xs);
            ++n2;
        }
    }

    public void register(XStream xs) {
        Preconditions.checkNotNull((Object)xs);
        log.trace("Registering converter for: {}", (Object)xs);
        xs.registerConverter((Converter)new InjectoConverter(xs.getMapper(), this.reflection), -20);
    }

    private class InjectoConverter
    extends RobustReflectionConverter {
        public InjectoConverter(Mapper mapper, ReflectionProvider provider) {
            super(mapper, provider);
        }

        public boolean canConvert(Class type) {
            return XStreamInjectoHandler.this.injecto.isInjectable(type);
        }

        public Object doUnmarshal(Object result, HierarchicalStreamReader reader, UnmarshallingContext context) {
            result = super.doUnmarshal(result, reader, context);
            log.trace("Injecting instance of Describable from converter");
            XStreamInjectoHandler.this.injecto.inject(result);
            return result;
        }
    }
}

