/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.inject.injecto.internal;

import com.google.inject.Key;
import org.aspectj.lang.JoinPoint;
import org.hudsonci.inject.Smoothie;
import org.hudsonci.inject.injecto.Injectomatic;
import org.hudsonci.inject.injecto.InjectomaticAware;
import org.hudsonci.inject.internal.OID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectomaticAspectHelper {
    private static final Logger log = LoggerFactory.getLogger(InjectomaticAspectHelper.class);
    private static boolean enabled = false;
    private static volatile Injectomatic injecto;

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(boolean enabled) {
        InjectomaticAspectHelper.enabled = enabled;
        log.debug("Aspect-based injection {}", (Object)(enabled ? "enabled" : "disabled"));
        injecto = enabled ? (Injectomatic)Smoothie.getContainer().get(Key.get(Injectomatic.class)) : null;
    }

    static void inject(JoinPoint joinPoint) {
        if (enabled) {
            Object target = joinPoint.getThis();
            if (log.isTraceEnabled()) {
                log.trace("Requesting injecting; join-point: {}, target: {}", (Object)joinPoint, (Object)OID.get(target));
            }
            injecto.inject(target);
        } else if (log.isTraceEnabled()) {
            log.trace("Aspect-based injection is disabled; ignoring join-point: {}", (Object)joinPoint);
        }
    }

    static void install(JoinPoint joinPoint) {
        if (enabled) {
            Object target = joinPoint.getThis();
            if (log.isTraceEnabled()) {
                log.trace("Installing; join-point: {}, target: {}", (Object)joinPoint, (Object)OID.get(target));
            }
            ((InjectomaticAware)InjectomaticAware.class.cast(target)).setInjectomatic(injecto);
        } else if (log.isTraceEnabled()) {
            log.trace("Aspect-based injection is disabled; ignoring join-point: {}", (Object)joinPoint);
        }
    }
}

