/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.inject.internal.plugin;

import com.google.common.base.Preconditions;
import hudson.ClassicPluginStrategy;
import hudson.PluginManager;
import hudson.PluginStrategy;
import hudson.PluginWrapper;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hudsonci.inject.internal.plugin.PluginClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class PluginWrapperFactory {
    private static final Logger log = LoggerFactory.getLogger(PluginWrapperFactory.class);
    private final PluginStrategy delegate;

    @Inject
    public PluginWrapperFactory(PluginManager plugins) {
        Preconditions.checkNotNull((Object)plugins);
        this.delegate = new ClassicPluginStrategy(plugins){

            protected ClassLoader createClassLoader(List<File> files, ClassLoader parent, Attributes atts) throws IOException {
                if (!$assertionsDisabled && files == null) {
                    throw new AssertionError();
                }
                ArrayList<URL> urls = new ArrayList<URL>(files.size());
                for (File file : files) {
                    urls.add(file.toURI().toURL());
                }
                return new PluginClassLoader(urls, parent);
            }
        };
    }

    public PluginWrapper create(File file) throws Exception {
        Preconditions.checkNotNull((Object)file);
        log.trace("Creating plugin wrapper for: {}", (Object)file);
        PluginWrapper plugin = this.delegate.createPluginWrapper(file);
        PluginClassLoader cl = (PluginClassLoader)((Object)plugin.classLoader);
        cl.setPlugin(plugin);
        return plugin;
    }
}

