/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.jaxb;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import org.jvnet.jaxb2_commons.plugin.AbstractParameterizablePlugin;

public class CloneablePlugin
extends AbstractParameterizablePlugin {
    public String getOptionName() {
        return "Xcloneable";
    }

    public String getUsage() {
        return "Adds Cloneable and Object.clone() implementation to all classes.";
    }

    protected boolean run(Outline outline, Options options) throws Exception {
        assert (outline != null);
        assert (options != null);
        for (ClassOutline type : outline.getClasses()) {
            this.processClassOutline(type);
        }
        return true;
    }

    private void processClassOutline(ClassOutline outline) {
        assert (outline != null);
        JDefinedClass type = outline.implClass;
        JCodeModel model = type.owner();
        type._implements(model.ref(Cloneable.class));
        JMethod method = type.method(1, (JType)outline.implRef, "clone");
        method.annotate(Override.class);
        JBlock body = method.body();
        JTryBlock block = body._try();
        block.body()._return((JExpression)JExpr.cast((JType)outline.implRef, (JExpression)JExpr._super().invoke("clone")));
        block._catch(model.ref(CloneNotSupportedException.class)).body()._throw((JExpression)JExpr._new((JClass)model.ref(InternalError.class)));
    }
}

