/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.rest.api.build;

import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.SuiteResult;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.test.AbstractTestResultAction;
import org.hudsonci.rest.api.internal.ConverterSupport;
import org.hudsonci.rest.model.build.TestCaseDTO;
import org.hudsonci.rest.model.build.TestCaseStatusDTO;
import org.hudsonci.rest.model.build.TestSuiteDTO;
import org.hudsonci.rest.model.build.TestsDTO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestsConverter
extends ConverterSupport {
    public TestsDTO convert(AbstractTestResultAction<?> source) {
        assert (source != null);
        if (source instanceof TestResultAction) {
            return this.convert((TestResultAction)source);
        }
        this.log.trace("Converting (ATRA): {}", source);
        TestsDTO target = new TestsDTO();
        target.setTotal(source.getTotalCount());
        target.setFailed(source.getFailCount());
        target.setSkipped(source.getSkipCount());
        return target;
    }

    public TestsDTO convert(TestResultAction source) {
        assert (source != null);
        this.log.trace("Converting (TRA): {}", (Object)source);
        TestsDTO target = new TestsDTO();
        target.setTotal(source.getTotalCount());
        target.setFailed(source.getFailCount());
        target.setSkipped(source.getSkipCount());
        TestResult result = source.getResult();
        for (SuiteResult suite : result.getSuites()) {
            target.getSuites().add(this.convert(suite));
        }
        return target;
    }

    public TestSuiteDTO convert(SuiteResult source) {
        assert (source != null);
        this.log.trace("Converting: {}", (Object)source);
        TestSuiteDTO target = new TestSuiteDTO();
        target.setName(source.getName());
        target.setTimeStamp(source.getTimestamp());
        target.setDuration(source.getDuration());
        for (CaseResult result : source.getCases()) {
            target.getCases().add(this.convert(result));
        }
        return target;
    }

    public TestCaseDTO convert(CaseResult source) {
        assert (source != null);
        this.log.trace("Converting: {}", (Object)source);
        TestCaseDTO target = new TestCaseDTO();
        target.setName(source.getName());
        target.setClassName(source.getClassName());
        target.setDuration(source.getDuration());
        target.setStatus(this.convert(source.getStatus()));
        target.setAge(source.getAge());
        target.setErrorDetails(source.getErrorDetails());
        target.setErrorStackTrace(source.getErrorStackTrace());
        return target;
    }

    public TestCaseStatusDTO convert(CaseResult.Status source) {
        assert (source != null);
        this.log.trace("Converting: {}", (Object)source);
        return TestCaseStatusDTO.valueOf((String)source.name().toUpperCase());
    }
}

