/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.rest.api.internal;

import com.google.common.base.Preconditions;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.hudsonci.rest.api.internal.PermissionConverter;
import org.hudsonci.rest.model.PermissionsDTO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionsFactory {
    private final PermissionConverter permx;

    @Inject
    PermissionsFactory(PermissionConverter permx) {
        this.permx = (PermissionConverter)Preconditions.checkNotNull((Object)permx);
    }

    public PermissionsDTO create(AccessControlled target) {
        assert (target != null);
        PermissionsDTO perms = new PermissionsDTO();
        for (Permission perm : this.findAllPermissions()) {
            if (!target.hasPermission(perm)) continue;
            perms.getPermissions().add(this.permx.convert(perm));
        }
        return perms;
    }

    private List<Permission> findAllPermissions() {
        ArrayList<Permission> perms = new ArrayList<Permission>();
        for (PermissionGroup group : PermissionGroup.getAll()) {
            perms.addAll(group.getPermissions());
        }
        return perms;
    }
}

