/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.rest.api.internal;

import com.google.common.base.Preconditions;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hudsonci.rest.common.ProjectNameCodec;
import org.hudsonci.service.BuildService;
import org.hudsonci.service.ProjectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
@Singleton
public class ProjectBuildHelper {
    private static final Logger log = LoggerFactory.getLogger(ProjectBuildHelper.class);
    private final ProjectService projectService;
    private final BuildService buildService;
    private final ProjectNameCodec projectNameCodec;

    @Inject
    public ProjectBuildHelper(ProjectService projectService, BuildService buildService, ProjectNameCodec projectNameCodec) {
        this.projectService = (ProjectService)Preconditions.checkNotNull((Object)projectService);
        this.buildService = (BuildService)Preconditions.checkNotNull((Object)buildService);
        this.projectNameCodec = (ProjectNameCodec)Preconditions.checkNotNull((Object)projectNameCodec);
    }

    public String decodeProjectName(String projectName) {
        return this.projectNameCodec.decode(projectName);
    }

    public AbstractProject<?, ?> getProject(String projectName) {
        Preconditions.checkNotNull((Object)projectName);
        return this.projectService.getProject(this.decodeProjectName(projectName));
    }

    public AbstractBuild<?, ?> getBuild(String projectName, int buildNumber) {
        AbstractProject<?, ?> project = this.getProject(projectName);
        return this.buildService.getBuild(project, buildNumber);
    }
}

