/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.rest.api.node;

import com.google.common.base.Preconditions;
import hudson.model.Node;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.hudsonci.rest.api.internal.ResourceSupport;
import org.hudsonci.rest.api.node.NodeConverter;
import org.hudsonci.rest.model.NodeDTO;
import org.hudsonci.rest.model.NodesDTO;
import org.hudsonci.service.NodeService;

@Named
@Path(value="/nodes")
public class NodeResource
extends ResourceSupport {
    private final NodeService nodeService;
    private final NodeConverter nodex;

    @Inject
    public NodeResource(NodeService nodeService, NodeConverter nodex) {
        this.nodeService = (NodeService)Preconditions.checkNotNull((Object)nodeService);
        this.nodex = (NodeConverter)Preconditions.checkNotNull((Object)nodex);
    }

    @GET
    public NodesDTO getNodes() {
        NodesDTO nodesToReturn = new NodesDTO();
        List allNodesIncludingMaster = this.nodeService.getAllNodes();
        for (Node node : allNodesIncludingMaster) {
            nodesToReturn.getNodes().add(this.nodex.convert(node));
        }
        return nodesToReturn;
    }

    @GET
    @Path(value="{nodeName}")
    public NodeDTO getNode(@PathParam(value="nodeName") String nodeName) {
        this.log.debug("Fetching node: {}", (Object)nodeName);
        return this.nodex.convert(this.nodeService.getNode(nodeName));
    }
}

