/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.rest.api.project;

import com.google.common.base.Preconditions;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Job;
import java.util.UUID;
import javax.inject.Inject;
import org.hudsonci.rest.api.build.BuildConverter;
import org.hudsonci.rest.api.internal.ConverterSupport;
import org.hudsonci.rest.api.project.HealthConverter;
import org.hudsonci.rest.model.project.ProjectDTO;
import org.hudsonci.rest.model.project.ProjectReferenceDTO;
import org.hudsonci.service.SystemService;
import org.hudsonci.utils.tasks.JobUuid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectConverter
extends ConverterSupport {
    private final SystemService systemService;
    private final BuildConverter buildx;
    private final HealthConverter healthx;
    private final JobUuid jobUuid;

    @Inject
    ProjectConverter(SystemService systemService, BuildConverter buildx, HealthConverter healthx, JobUuid jobUuid) {
        this.systemService = (SystemService)Preconditions.checkNotNull((Object)systemService);
        this.buildx = (BuildConverter)Preconditions.checkNotNull((Object)buildx);
        this.healthx = (HealthConverter)Preconditions.checkNotNull((Object)healthx);
        this.jobUuid = (JobUuid)Preconditions.checkNotNull((Object)jobUuid);
    }

    public ProjectDTO convert(AbstractProject<?, ?> source) {
        ProjectReferenceDTO ref;
        Preconditions.checkNotNull(source);
        this.log.trace("Converting: {}", source);
        ProjectDTO target = new ProjectDTO();
        ProjectReferenceDTO selfRef = new ProjectReferenceDTO();
        selfRef.setId(JobUuid.get(source).toString());
        target.setRef(selfRef);
        target.setType(source.getClass().getName());
        target.setUrl(String.format("%s/%s", this.systemService.getUrl(), source.getUrl()));
        UUID id = JobUuid.get(source);
        if (id != null) {
            target.setId(id.toString());
        }
        target.setName(source.getFullName());
        target.setTitle(source.getFullDisplayName());
        target.setDescription(source.getDescription());
        target.setEnabled(!source.isDisabled());
        target.setConfigurable(source.isConfigurable());
        target.setConcurrent(source.isConcurrentBuild());
        target.setQueued(source.isInQueue());
        if (source.getLastBuild() != null) {
            target.setLastBuild(this.buildx.convert((AbstractBuild)source.getLastBuild()));
        }
        target.setBlocked(Boolean.valueOf(source.isBuildBlocked()));
        target.setBlockedReason(source.getWhyBlocked());
        target.setHealth(this.healthx.convert(source.getBuildHealth()));
        if (source instanceof MatrixProject) {
            for (MatrixConfiguration child : ((MatrixProject)source).getActiveConfigurations()) {
                ref = new ProjectReferenceDTO();
                ref.setId(JobUuid.get((Job)child).toString());
                target.getDescendants().add(ref);
            }
        } else if (source instanceof MatrixConfiguration) {
            MatrixProject parent = ((MatrixConfiguration)source).getParent();
            ProjectReferenceDTO ref2 = new ProjectReferenceDTO();
            ref2.setId(JobUuid.get((Job)parent).toString());
            target.setParent(ref2);
        }
        for (AbstractProject project : source.getUpstreamProjects()) {
            ref = new ProjectReferenceDTO();
            ref.setId(JobUuid.get((Job)project).toString());
            target.getUpstreams().add(ref);
        }
        for (AbstractProject project : source.getDownstreamProjects()) {
            ref = new ProjectReferenceDTO();
            ref.setId(JobUuid.get((Job)project).toString());
            target.getDownstreams().add(ref);
        }
        return target;
    }
}

