/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.rest.api.project;

import com.google.common.base.Preconditions;
import hudson.XmlFile;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Cause;
import hudson.model.Item;
import hudson.model.Run;
import hudson.security.AccessControlled;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.hudsonci.rest.api.build.BuildConverter;
import org.hudsonci.rest.api.internal.PermissionsFactory;
import org.hudsonci.rest.api.internal.ProjectBuildHelper;
import org.hudsonci.rest.api.internal.ResourceSupport;
import org.hudsonci.rest.api.project.ProjectConverter;
import org.hudsonci.rest.model.PermissionsDTO;
import org.hudsonci.rest.model.build.BuildsDTO;
import org.hudsonci.rest.model.project.ProjectDTO;
import org.hudsonci.rest.model.project.ProjectsDTO;
import org.hudsonci.service.ProjectService;
import org.hudsonci.service.SecurityService;
import org.hudsonci.utils.io.Closer;

@Named
@Path(value="/projects")
public class ProjectsResource
extends ResourceSupport {
    private final ProjectBuildHelper support;
    private final ProjectService projectService;
    private final SecurityService securityService;
    private final ProjectConverter projectx;
    private final BuildConverter buildx;
    private final PermissionsFactory permissions;

    @Inject
    public ProjectsResource(ProjectBuildHelper support, SecurityService securityService, ProjectService projectService, ProjectConverter projectx, BuildConverter buildx, PermissionsFactory permissions) {
        this.support = (ProjectBuildHelper)Preconditions.checkNotNull((Object)support);
        this.securityService = (SecurityService)Preconditions.checkNotNull((Object)securityService);
        this.projectService = (ProjectService)Preconditions.checkNotNull((Object)projectService);
        this.projectx = (ProjectConverter)Preconditions.checkNotNull((Object)projectx);
        this.buildx = (BuildConverter)Preconditions.checkNotNull((Object)buildx);
        this.permissions = (PermissionsFactory)Preconditions.checkNotNull((Object)permissions);
    }

    @GET
    public ProjectsDTO getProjects() {
        ProjectsDTO projects = new ProjectsDTO();
        this.log.debug("Listing projects");
        for (AbstractProject project : this.projectService.getAllProjects()) {
            ProjectDTO dto = this.projectx.convert(project);
            projects.getProjects().add(dto);
        }
        return projects;
    }

    @GET
    @Path(value="copy")
    public ProjectDTO copyProject(@QueryParam(value="source") String projectName, @QueryParam(value="target") String targetProjectName) throws IOException {
        Preconditions.checkNotNull((Object)projectName);
        Preconditions.checkNotNull((Object)targetProjectName);
        projectName = this.support.decodeProjectName(projectName);
        targetProjectName = this.support.decodeProjectName(targetProjectName);
        this.log.debug("Copying project: {} -> {}", (Object)projectName, (Object)targetProjectName);
        if (this.projectService.projectExists(targetProjectName)) {
            throw new WebApplicationException(Response.Status.CONFLICT);
        }
        AbstractProject<?, ?> source = this.support.getProject(projectName);
        AbstractProject target = this.projectService.copyProject(source, targetProjectName);
        return this.projectx.convert(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"text/xml"})
    @Path(value="{projectName}")
    public ProjectDTO createProject(@PathParam(value="projectName") String projectName, InputStream configXml) throws IOException {
        Preconditions.checkNotNull((Object)projectName);
        Preconditions.checkNotNull((Object)configXml);
        projectName = this.support.decodeProjectName(projectName);
        this.log.debug("Creating project: {}", (Object)projectName);
        if (this.projectService.projectExists(projectName)) {
            throw new WebApplicationException(Response.Status.CONFLICT);
        }
        BufferedInputStream input = new BufferedInputStream(configXml);
        try {
            this.projectService.createProjectFromXML(projectName, (InputStream)input);
        }
        catch (Throwable throwable) {
            Closer.close((Closeable[])new Closeable[]{input});
            throw throwable;
        }
        Closer.close((Closeable[])new Closeable[]{input});
        AbstractProject project = this.projectService.getProject(projectName);
        return this.projectx.convert(project);
    }

    @GET
    @Path(value="{projectName}")
    public ProjectDTO getProject(@PathParam(value="projectName") String projectName) {
        this.log.debug("Fetching project: {}", (Object)projectName);
        AbstractProject<?, ?> project = this.support.getProject(projectName);
        return this.projectx.convert(project);
    }

    @DELETE
    @Path(value="{projectName}")
    public void deleteProject(@PathParam(value="projectName") String projectName) throws Exception {
        this.log.debug("Deleting project: {}", (Object)projectName);
        AbstractProject<?, ?> project = this.support.getProject(projectName);
        project.checkPermission(Item.DELETE);
        project.delete();
    }

    @GET
    @Path(value="{projectName}/config")
    @Produces(value={"text/xml"})
    public String getProjectConfig(@PathParam(value="projectName") String projectName) throws IOException {
        this.log.debug("Fetching project configuration: {}", (Object)projectName);
        AbstractProject<?, ?> project = this.support.getProject(projectName);
        project.checkPermission(Item.EXTENDED_READ);
        XmlFile file = project.getConfigFile();
        return file.asString();
    }

    @GET
    @Path(value="{projectName}/enable")
    public Response enableProject(@PathParam(value="projectName") String projectName, @QueryParam(value="enable") @DefaultValue(value="true") boolean enable) {
        this.log.debug("Project {}: {}", (Object)(enable ? "enabled" : "disabled"), (Object)projectName);
        AbstractProject<?, ?> project = this.support.getProject(projectName);
        project.checkPermission(Item.CONFIGURE);
        try {
            if (enable) {
                project.enable();
            } else {
                project.disable();
            }
            return Response.noContent().build();
        }
        catch (Exception e) {
            this.log.error("Failed to enable/disable project", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="{projectName}/schedule")
    public Response scheduleBuild(@PathParam(value="projectName") String projectName) {
        this.log.debug("Scheduling build: {}", (Object)projectName);
        AbstractProject<?, ?> project = this.support.getProject(projectName);
        if (!project.isBuildable()) {
            throw new RuntimeException("Project not buildable: " + projectName);
        }
        project.checkPermission(Item.BUILD);
        project.scheduleBuild((Cause)new Cause.UserCause());
        return Response.noContent().build();
    }

    @GET
    @Path(value="{projectName}/builds")
    public BuildsDTO getBuilds(@PathParam(value="projectName") String projectName) {
        this.log.debug("Listing builds for project: {}", (Object)projectName);
        AbstractProject<?, ?> project = this.support.getProject(projectName);
        project.checkPermission(Item.READ);
        BuildsDTO builds = new BuildsDTO();
        for (AbstractBuild build : project.getBuilds()) {
            if (!build.hasPermission(Item.READ)) continue;
            builds.getBuilds().add(this.buildx.convert((Run<?, ?>)build));
        }
        return builds;
    }

    @GET
    @Path(value="{projectName}/permissions")
    public PermissionsDTO getPermissions(@PathParam(value="projectName") String projectName) {
        this.log.debug("Getting permissions for project: {}", (Object)projectName);
        AbstractProject<?, ?> project = this.support.getProject(projectName);
        project.checkPermission(Item.READ);
        return this.permissions.create((AccessControlled)project);
    }
}

