/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.rest.api.build;

import com.google.common.base.Preconditions;
import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.User;
import hudson.scm.ChangeLogSet;
import java.util.List;
import javax.inject.Inject;
import org.hudsonci.rest.api.build.CauseConverter;
import org.hudsonci.rest.api.internal.ConverterSupport;
import org.hudsonci.rest.model.build.BuildDTO;
import org.hudsonci.rest.model.build.BuildResultDTO;
import org.hudsonci.rest.model.build.BuildStateDTO;
import org.hudsonci.service.SystemService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildConverter
extends ConverterSupport {
    private final SystemService systemService;
    private final CauseConverter causex;

    @Inject
    public BuildConverter(SystemService systemService, CauseConverter causex) {
        this.systemService = (SystemService)Preconditions.checkNotNull((Object)systemService);
        this.causex = (CauseConverter)Preconditions.checkNotNull((Object)causex);
    }

    public BuildDTO convert(AbstractBuild<?, ?> source) {
        assert (source != null);
        this.log.trace("Converting: {}", source);
        BuildDTO target = new BuildDTO();
        target.setType(source.getClass().getName());
        target.setUrl(String.format("%s/%s", this.systemService.getUrl(), source.getUrl()));
        target.setId(source.getId());
        target.setNumber(source.getNumber());
        target.setDescription(source.getDescription());
        target.setProjectName(source.getProject().getFullName());
        target.setDuration(Long.valueOf(source.getDuration()));
        target.setTimeStamp(source.getTimestamp().getTimeInMillis());
        if (source.getResult() != null) {
            target.setResult(this.convert(source.getResult()));
        }
        if (source.hasntStartedYet()) {
            target.setState(BuildStateDTO.NOT_STARTED);
        } else if (source.isBuilding()) {
            target.setState(BuildStateDTO.BUILDING);
        } else if (source.isLogUpdated()) {
            target.setState(BuildStateDTO.POST_PRODUCTION);
        } else {
            target.setState(BuildStateDTO.COMPLETED);
        }
        List culprits = target.getCulprits();
        for (User user : source.getCulprits()) {
            String uid = user.getId();
            if (culprits.contains(uid)) continue;
            culprits.add(uid);
        }
        List participants = target.getParticipants();
        for (ChangeLogSet.Entry entry : source.getChangeSet()) {
            String uid = entry.getAuthor().getId();
            if (participants.contains(uid)) continue;
            participants.add(uid);
        }
        target.setKept(source.isKeepLog());
        target.getCauses().addAll(this.causex.convert(source.getCauses()));
        target.setChangesAvailable(source.getChangeSet() != null && !source.getChangeSet().isEmptySet());
        target.setTestsAvailable(source.getTestResultAction() != null && source.getTestResultAction().getTotalCount() != 0);
        return target;
    }

    public BuildDTO convert(Run<?, ?> source) {
        assert (source != null);
        this.log.trace("Converting: {}", source);
        return this.convert((AbstractBuild)source);
    }

    public BuildResultDTO convert(Result source) {
        assert (source != null);
        this.log.trace("Converting: {}", (Object)source);
        return BuildResultDTO.valueOf((String)source.toString().toUpperCase());
    }
}

