/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.rest.api.build;

import com.google.common.base.Preconditions;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.tasks.test.AbstractTestResultAction;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.hudsonci.rest.api.build.BuildConverter;
import org.hudsonci.rest.api.build.ChangesConverter;
import org.hudsonci.rest.api.build.TestsConverter;
import org.hudsonci.rest.api.internal.ProjectBuildHelper;
import org.hudsonci.rest.api.internal.ResourceSupport;
import org.hudsonci.rest.model.build.BuildDTO;
import org.hudsonci.rest.model.build.ChangesDTO;
import org.hudsonci.rest.model.build.ConsoleDTO;
import org.hudsonci.rest.model.build.TestsDTO;
import org.hudsonci.service.BuildService;
import org.hudsonci.service.ProjectService;
import org.hudsonci.utils.common.Varargs;
import org.hudsonci.utils.io.OffsetLimitInputStream;

@Named
@Path(value="/projects/{projectName}/{buildNumber:\\d*}")
public class BuildResource
extends ResourceSupport {
    private final ProjectService projectService;
    private final BuildService buildService;
    private final ProjectBuildHelper support;
    private final BuildConverter buildx;
    private final ChangesConverter changesx;
    private final TestsConverter testsx;

    @Inject
    public BuildResource(ProjectService projectService, BuildService buildService, ProjectBuildHelper support, BuildConverter buildx, ChangesConverter changesx, TestsConverter testsx) {
        this.projectService = (ProjectService)Preconditions.checkNotNull((Object)projectService);
        this.buildService = (BuildService)Preconditions.checkNotNull((Object)buildService);
        this.support = (ProjectBuildHelper)Preconditions.checkNotNull((Object)support);
        this.buildx = (BuildConverter)Preconditions.checkNotNull((Object)buildx);
        this.changesx = (ChangesConverter)Preconditions.checkNotNull((Object)changesx);
        this.testsx = (TestsConverter)Preconditions.checkNotNull((Object)testsx);
    }

    @GET
    public BuildDTO getBuild(@PathParam(value="projectName") String projectName, @PathParam(value="buildNumber") int buildNumber) {
        this.log.debug("Fetching build: {} #{}", (Object)projectName, (Object)buildNumber);
        AbstractBuild<?, ?> build = this.support.getBuild(projectName, buildNumber);
        return this.buildx.convert(build);
    }

    @DELETE
    public void deleteBuild(@PathParam(value="projectName") String projectName, @PathParam(value="buildNumber") int buildNumber) {
        this.log.debug("Deleting build: {} #{}", (Object)projectName, (Object)buildNumber);
        AbstractProject<?, ?> project = this.support.getProject(projectName);
        this.buildService.deleteBuild(project, buildNumber);
    }

    @GET
    @Path(value="keep")
    public Response keepBuild(@PathParam(value="projectName") String projectName, @PathParam(value="buildNumber") int buildNumber, @QueryParam(value="release") @DefaultValue(value="false") boolean release) {
        this.log.debug("{} build: {} #{}", new Object[]{release ? "Releasing" : "Keeping", projectName, buildNumber});
        AbstractProject<?, ?> project = this.support.getProject(projectName);
        this.buildService.keepBuild(project, buildNumber, release);
        return Response.noContent().build();
    }

    @PUT
    @Path(value="stop")
    public void stopBuild(@PathParam(value="projectName") String projectName, @PathParam(value="buildNumber") int buildNumber) {
        this.log.debug("Stopping build: {} #{}", (Object)projectName, (Object)buildNumber);
        AbstractProject<?, ?> project = this.support.getProject(projectName);
        this.buildService.stopBuild(project, buildNumber);
    }

    @GET
    @Path(value="changes")
    public ChangesDTO getChanges(@PathParam(value="projectName") String projectName, @PathParam(value="buildNumber") int buildNumber) {
        this.log.debug("Get changes: {} #{}", (Object)projectName, (Object)buildNumber);
        AbstractBuild<?, ?> build = this.support.getBuild(projectName, buildNumber);
        if (build.getChangeSet().isEmptySet()) {
            throw new WebApplicationException(Response.Status.NO_CONTENT);
        }
        return this.changesx.convert(build.getChangeSet());
    }

    @GET
    @Path(value="tests")
    public TestsDTO getTests(@PathParam(value="projectName") String projectName, @PathParam(value="buildNumber") int buildNumber) {
        this.log.debug("Get tests: {} #{}", (Object)projectName, (Object)buildNumber);
        AbstractBuild<?, ?> build = this.support.getBuild(projectName, buildNumber);
        AbstractTestResultAction action = build.getTestResultAction();
        if (action == null || action.getTotalCount() == 0) {
            throw new WebApplicationException(Response.Status.NO_CONTENT);
        }
        return this.testsx.convert(build.getTestResultAction());
    }

    @GET
    @Path(value="console")
    public ConsoleDTO getConsole(@PathParam(value="projectName") String projectName, @PathParam(value="buildNumber") int buildNumber) throws IOException {
        this.log.debug("Get console: {} #{}", (Object)projectName, (Object)buildNumber);
        AbstractBuild<?, ?> build = this.support.getBuild(projectName, buildNumber);
        File file = build.getLogFile();
        ConsoleDTO target = new ConsoleDTO();
        target.setExists(file.exists());
        if (file.exists()) {
            target.setLength(Long.valueOf(file.length()));
            target.setLastModified(Long.valueOf(file.lastModified()));
        }
        return target;
    }

    @GET
    @Path(value="console/content")
    @Produces(value={"text/plain"})
    public InputStream getConsoleContent(@PathParam(value="projectName") String projectName, @PathParam(value="buildNumber") int buildNumber, @QueryParam(value="offset") long offset, @QueryParam(value="length") long length) throws IOException {
        this.log.debug("Get console content: {} #{} ({}:{})", Varargs.$((Object[])new Serializable[]{projectName, Integer.valueOf(buildNumber), Long.valueOf(offset), Long.valueOf(length)}));
        AbstractBuild<?, ?> build = this.support.getBuild(projectName, buildNumber);
        File file = build.getLogFile();
        return new OffsetLimitInputStream((InputStream)new FileInputStream(file), offset, length);
    }
}

