/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.rest.api.internal;

import com.google.common.base.Preconditions;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.hudsonci.rest.common.Constants;
import org.hudsonci.rest.model.fault.FaultDTO;
import org.hudsonci.rest.model.fault.FaultException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
public class FaultExceptionMapper
implements ExceptionMapper<FaultException> {
    private static final Logger log = LoggerFactory.getLogger(FaultExceptionMapper.class);

    public Response toResponse(FaultException cause) {
        Preconditions.checkNotNull((Object)cause);
        FaultDTO fault = cause.getFault();
        log.warn("Generating fault response; ID: {}", (Object)fault.getId());
        return Response.serverError().entity((Object)fault).type(Constants.FAULT_v1_JSON_TYPE).build();
    }
}

