/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.rest.api.internal;

import com.google.common.base.Preconditions;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
public class WebApplicationExceptionMapper
implements ExceptionMapper<WebApplicationException> {
    private static final Logger log = LoggerFactory.getLogger(WebApplicationExceptionMapper.class);

    public Response toResponse(WebApplicationException cause) {
        Preconditions.checkNotNull((Object)cause);
        Response resp = cause.getResponse();
        if (log.isDebugEnabled()) {
            StringBuilder buff = new StringBuilder();
            buff.append(cause.getClass().getSimpleName());
            buff.append(" [");
            int code = resp.getStatus();
            buff.append(code).append("]");
            Response.Status status = Response.Status.fromStatusCode((int)code);
            if (status != null) {
                buff.append(" ").append(status);
            }
            if (log.isTraceEnabled()) {
                log.trace("{}", (Object)buff, (Object)cause);
            } else {
                log.debug("{}", (Object)buff);
            }
        }
        return resp;
    }
}

