/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.rest.api.project;

import com.google.common.base.Preconditions;
import hudson.model.AbstractProject;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.hudsonci.rest.api.internal.ResourceSupport;
import org.hudsonci.rest.api.project.ProjectConverter;
import org.hudsonci.rest.model.project.ProjectDTO;
import org.hudsonci.service.ProjectService;

@Named
@Path(value="/project")
public class ProjectResource
extends ResourceSupport {
    private final ProjectService projectService;
    private final ProjectConverter projectx;

    @Inject
    public ProjectResource(ProjectService projectService, ProjectConverter projectx) {
        this.projectService = (ProjectService)Preconditions.checkNotNull((Object)projectService);
        this.projectx = (ProjectConverter)Preconditions.checkNotNull((Object)projectx);
    }

    @GET
    @Path(value="{projectId}")
    public ProjectDTO getProject(@PathParam(value="projectId") String projectId) {
        Preconditions.checkNotNull((Object)projectId);
        this.log.debug("Fetching project-by-id: {}", (Object)projectId);
        UUID id = UUID.fromString(projectId);
        AbstractProject project = this.projectService.getProject(id);
        return this.projectx.convert(project);
    }
}

