/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.rest.api.status;

import com.google.common.base.Preconditions;
import hudson.model.Hudson;
import hudson.model.User;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import org.hudsonci.rest.api.internal.ResourceSupport;
import org.hudsonci.rest.api.status.StatusConverter;
import org.hudsonci.rest.api.user.UserConverter;
import org.hudsonci.rest.model.StatusDTO;
import org.hudsonci.service.SecurityService;
import org.hudsonci.service.SystemService;

@Named
@Path(value="status")
public class StatusResource
extends ResourceSupport {
    private final SystemService systemService;
    private final SecurityService securityService;
    private final StatusConverter statusx;
    private final UserConverter userx;

    @Inject
    public StatusResource(SystemService systemService, SecurityService securityService, StatusConverter statusx, UserConverter userx) {
        this.systemService = (SystemService)Preconditions.checkNotNull((Object)systemService);
        this.securityService = (SecurityService)Preconditions.checkNotNull((Object)securityService);
        this.statusx = (StatusConverter)Preconditions.checkNotNull((Object)statusx);
        this.userx = (UserConverter)Preconditions.checkNotNull((Object)userx);
    }

    @GET
    public StatusDTO getStatus() {
        this.log.debug("Returning status");
        this.securityService.checkPermission(Hudson.READ);
        StatusDTO status = new StatusDTO();
        status.setUrl(this.systemService.getUrl());
        status.setVersion(this.systemService.getVersion());
        status.setInitLevel(this.statusx.convert(this.systemService.getInitLevel()));
        status.setQuietingDown(this.systemService.isQuietingDown());
        status.setTerminating(this.systemService.isTerminating());
        status.setSystemMessage(this.systemService.getSystemMessage());
        User user = this.securityService.getCurrentUser();
        if (user != null) {
            status.setUser(this.userx.convert(user));
        }
        return status;
    }
}

