/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.rest.api.admin;

import com.google.common.base.Preconditions;
import hudson.XmlFile;
import hudson.lifecycle.RestartNotSupportedException;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.hudsonci.rest.api.internal.ResourceSupport;
import org.hudsonci.service.SystemService;

@Named
@Path(value="/admin")
public class AdminResource
extends ResourceSupport {
    private final SystemService systemService;

    @Inject
    public AdminResource(SystemService systemService) {
        this.systemService = (SystemService)Preconditions.checkNotNull((Object)systemService);
    }

    @GET
    @Path(value="config")
    @Produces(value={"text/xml"})
    public Response getConfig() {
        XmlFile file = this.systemService.getConfigFile();
        this.log.debug("Config file: {}", (Object)file);
        if (!file.exists()) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        try {
            String xml = file.asString();
            return Response.ok((Object)xml).build();
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="quiet-down")
    public Response quietDown(@QueryParam(value="toggle") @DefaultValue(value="true") boolean toggle) {
        this.systemService.doQuietDown(toggle);
        return Response.noContent().build();
    }

    @GET
    @Path(value="config/reload")
    public Response reloadConfiguration() throws IOException {
        this.systemService.doReload();
        return Response.noContent().build();
    }

    @GET
    @Path(value="restart")
    public Response restart(@QueryParam(value="safe") @DefaultValue(value="false") boolean safe) throws RestartNotSupportedException {
        this.systemService.doRestart(safe);
        return Response.noContent().build();
    }
}

