/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.rest.api.build;

import hudson.scm.ChangeLogSet;
import hudson.scm.EditType;
import javax.inject.Inject;
import org.hudsonci.rest.api.internal.ConverterSupport;
import org.hudsonci.rest.api.user.UserConverter;
import org.hudsonci.rest.model.build.ChangeEntryDTO;
import org.hudsonci.rest.model.build.ChangeFileDTO;
import org.hudsonci.rest.model.build.ChangeTypeDTO;
import org.hudsonci.rest.model.build.ChangesDTO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangesConverter
extends ConverterSupport {
    @Inject
    private UserConverter userx;

    public ChangesDTO convert(ChangeLogSet<?> source) {
        assert (source != null);
        this.log.trace("Converting: {}", source);
        ChangesDTO target = new ChangesDTO();
        target.setKind(source.getKind());
        for (ChangeLogSet.Entry entry : source) {
            target.getEntries().add(this.convert(entry));
        }
        return target;
    }

    public ChangeEntryDTO convert(ChangeLogSet.Entry source) {
        assert (source != null);
        this.log.trace("Converting: {}", (Object)source);
        ChangeEntryDTO target = new ChangeEntryDTO();
        target.setMessage(source.getMsgAnnotated());
        target.setAuthor(this.userx.convert(source.getAuthor()));
        for (String path : source.getAffectedPaths()) {
            target.getPaths().add(path);
        }
        try {
            for (ChangeLogSet.AffectedFile file : source.getAffectedFiles()) {
                target.getFiles().add(this.convert(file));
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return target;
    }

    public ChangeFileDTO convert(ChangeLogSet.AffectedFile source) {
        assert (source != null);
        this.log.trace("Converting: {}", (Object)source);
        ChangeFileDTO target = new ChangeFileDTO();
        target.setPath(source.getPath());
        target.setType(this.convert(source.getEditType()));
        return target;
    }

    public ChangeTypeDTO convert(EditType source) {
        assert (source != null);
        this.log.trace("Converting: {}", (Object)source);
        return ChangeTypeDTO.valueOf((String)source.getName().toUpperCase());
    }
}

