/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.rest.api.internal;

import hudson.init.InitMilestone;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.hudsonci.rest.api.Version;
import org.hudsonci.rest.api.internal.ResourceSupport;
import org.hudsonci.service.SystemService;

@Named
@Path(value="handshake")
@Produces(value={"text/plain"})
public class HandshakeResource
extends ResourceSupport {
    private final SystemService systemService;
    private final String[] acceptVersions;

    @Inject
    public HandshakeResource(SystemService systemService) {
        this.systemService = systemService;
        String versions = System.getProperty(this.getClass().getName() + ".acceptVersionsOverride");
        if (versions != null) {
            this.log.warn("Override accept versions: {}", (Object)versions);
            this.acceptVersions = versions.split(",");
        } else {
            this.acceptVersions = new String[]{this.getApiVersion()};
        }
    }

    private String getApiVersion() {
        return Version.get().getVersion();
    }

    @GET
    public String handshake(@HeaderParam(value="X-Hudson") String details) {
        String[] parts;
        this.log.debug("Handshake: {}", (Object)details);
        if (details == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        if (this.systemService.getInitLevel() != InitMilestone.COMPLETED) {
            throw new WebApplicationException(Response.Status.SERVICE_UNAVAILABLE);
        }
        String id = null;
        String version = null;
        for (String part : parts = details.split(";")) {
            if (part.startsWith("client=")) {
                version = part.substring(7, part.length());
            }
            if (!part.startsWith("id=")) continue;
            id = part.substring(3, part.length());
        }
        if (id != null && version != null) {
            for (String acceptVersion : this.acceptVersions) {
                if (!acceptVersion.equals(version)) continue;
                return id;
            }
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.CONFLICT).type("text/plain").entity((Object)String.format("Client version is unsupported: %s", version)).build());
        }
        throw new WebApplicationException(Response.Status.BAD_REQUEST);
    }
}

