/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.rest.api.internal;

import com.google.common.base.Preconditions;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.hudsonci.service.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
public class NotFoundExceptionMapper
implements ExceptionMapper<NotFoundException> {
    private static final Logger log = LoggerFactory.getLogger(NotFoundExceptionMapper.class);

    public Response toResponse(NotFoundException cause) {
        Preconditions.checkNotNull((Object)cause);
        String message = cause.getMessage();
        log.debug("Generating NOT_FOUND response: {}", (Object)message);
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)cause.getMessage()).build();
    }
}

