/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.rest.api.user;

import com.google.common.base.Preconditions;
import hudson.model.User;
import hudson.security.Permission;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.hudsonci.rest.api.internal.ResourceSupport;
import org.hudsonci.rest.api.user.UserConverter;
import org.hudsonci.rest.model.UserDTO;
import org.hudsonci.service.SecurityService;

@Named
@Path(value="/users")
public class UserResource
extends ResourceSupport {
    private final SecurityService securityService;
    private final UserConverter userx;

    @Inject
    public UserResource(SecurityService securityService, UserConverter userx) {
        this.securityService = (SecurityService)Preconditions.checkNotNull((Object)securityService);
        this.userx = (UserConverter)Preconditions.checkNotNull((Object)userx);
    }

    @GET
    @Path(value="{userName}")
    public UserDTO getUser(@PathParam(value="userName") String userName) {
        Preconditions.checkNotNull((Object)userName);
        this.log.debug("Getting user: {}", (Object)userName);
        User user = this.securityService.getUser(userName);
        this.log.debug("Getting user with ID: {}", (Object)user.getId());
        user.checkPermission(Permission.READ);
        return this.userx.convert(user);
    }
}

