/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.rest.common;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.inject.Named;
import javax.inject.Singleton;

@Named
@Singleton
public class ProjectNameCodec {
    public String encode(String projectName) {
        try {
            return URLEncoder.encode(projectName.replace('/', '@'), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    public String decode(String projectName) {
        try {
            return URLDecoder.decode(projectName, "UTF-8").replace('@', '/');
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }
}

