/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.rest.common;

import com.google.common.base.Preconditions;
import java.util.UUID;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RestPreconditions {
    protected static final Logger log = LoggerFactory.getLogger(RestPreconditions.class);

    protected RestPreconditions() {
    }

    public static int checkBuildNumber(int buildNumber) {
        if (buildNumber < 1) {
            RestPreconditions.throwBadRequest("build number was " + buildNumber + " - must be greater than zero");
        }
        return buildNumber;
    }

    public static int checkBuildStateIndex(int index) {
        if (RestPreconditions.isNegative(index)) {
            RestPreconditions.throwBadRequest("build state index was " + index + " - must be zero or greater");
        }
        return index;
    }

    public static int checkBuilderIndex(int index) {
        if (RestPreconditions.isNegative(index)) {
            RestPreconditions.throwBadRequest("builder index was " + index + " - must be zero or greater");
        }
        return index;
    }

    public static String checkProjectName(String projectName) {
        if (projectName == null) {
            RestPreconditions.throwBadRequest("project name must not be null");
        }
        return projectName;
    }

    public static String checkDocumentId(String id) {
        RestPreconditions.checkNotNull(id, "Document ID");
        RestPreconditions.checkUUID(id);
        return id;
    }

    protected static void checkUUID(String uuid) {
        try {
            UUID.fromString(uuid);
        }
        catch (IllegalArgumentException e) {
            RestPreconditions.throwBadRequest("Document ID could not be parsed into a UUID");
        }
    }

    public static <T> T checkNotNull(T reference, String msgKey) {
        if (reference == null) {
            RestPreconditions.throwBadRequest(msgKey + " must not be null.");
        }
        return reference;
    }

    public static <T> T checkNotNull(T reference, Class<T> clazz) {
        if (reference == null) {
            RestPreconditions.throwBadRequest(clazz == null ? "Required value" : clazz.getName() + " must not be null.");
        }
        return reference;
    }

    public static void throwBadRequest(String message) {
        RestPreconditions.throwWebApplicationException(Response.Status.BAD_REQUEST, message);
    }

    public static void throwConflict(String message) {
        RestPreconditions.throwWebApplicationException(Response.Status.CONFLICT, message);
    }

    public static void throwWebApplicationException(Response.Status status, String message) {
        Preconditions.checkNotNull((Object)status);
        log.info("precondition {} ({}) {}", new Object[]{status.getReasonPhrase(), status.getStatusCode(), message});
        Response resp = Response.status((Response.Status)status).entity((Object)(status.getFamily().toString() + ":" + message)).build();
        throw new WebApplicationException(resp);
    }

    protected static boolean isNegative(int index) {
        return index < 0;
    }
}

