/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.rest.common;

import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.jackson.map.ObjectMapper;
import org.hudsonci.rest.common.JsonCodec;
import org.hudsonci.rest.common.ObjectMapperProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
@Singleton
public class JacksonCodec
implements JsonCodec {
    private final ObjectMapper mapper;

    @Inject
    public JacksonCodec(ObjectMapper mapper) {
        this.mapper = (ObjectMapper)Preconditions.checkNotNull((Object)mapper);
    }

    public JacksonCodec() {
        this(new ObjectMapperProvider().get());
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    @Override
    public String encode(Object value) throws IOException {
        Preconditions.checkNotNull((Object)value);
        return this.mapper.writeValueAsString(value);
    }

    @Override
    public <T> T decode(String value, Class<T> type) throws IOException {
        Preconditions.checkNotNull((Object)value);
        Preconditions.checkNotNull(type);
        return (T)this.mapper.readValue(value, type);
    }
}

