/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.rest.model.fault;

import java.util.Iterator;
import org.hudsonci.rest.model.fault.FaultBuilder;
import org.hudsonci.rest.model.fault.FaultDTO;
import org.hudsonci.rest.model.fault.FaultDetailDTO;

public class FaultException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final FaultDTO fault;

    public FaultException(FaultDTO fault) {
        assert (fault != null);
        this.fault = fault;
    }

    public FaultException(String type, String message) {
        this(FaultBuilder.build(type, message));
    }

    public FaultDTO getFault() {
        return this.fault;
    }

    public String getMessage() {
        StringBuffer buff = new StringBuffer();
        buff.append("Fault: ").append(this.fault.getId()).append("\n");
        Iterator<FaultDetailDTO> iter = this.fault.getDetails().iterator();
        while (iter.hasNext()) {
            FaultDetailDTO detail = iter.next();
            buff.append(String.format("[%s] %s", detail.getType(), detail.getMessage()));
            if (!iter.hasNext()) continue;
            buff.append(", ");
        }
        return buff.toString();
    }
}

