/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.rest.model.fault;

import com.google.common.base.Preconditions;
import java.util.UUID;
import org.hudsonci.rest.model.fault.FaultDTO;
import org.hudsonci.rest.model.fault.FaultDetailDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FaultBuilder {
    private static final Logger log = LoggerFactory.getLogger(FaultBuilder.class);

    public static FaultDTO build(String type, String message) {
        return new FaultDTO().withId(FaultBuilder.generateId()).withDetails(FaultBuilder.detail(type, message));
    }

    private static String generateId() {
        return UUID.randomUUID().toString();
    }

    private static FaultDetailDTO detail(String type, String message) {
        Preconditions.checkNotNull((Object)type);
        return new FaultDetailDTO().withType(type).withMessage(message);
    }

    public static FaultDTO build(Throwable cause) {
        Preconditions.checkNotNull((Object)cause);
        log.warn("Building fault for: {}", (Object)cause.toString(), (Object)cause);
        FaultDTO fault = FaultBuilder.build(cause.getClass().getName(), cause.getMessage());
        return fault;
    }
}

