/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.rest.server.internal.jersey;

import com.google.common.base.Preconditions;
import com.google.inject.Key;
import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProvider;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProviderFactory;
import com.sun.jersey.core.spi.component.ioc.IoCInstantiatedComponentProvider;
import java.util.Iterator;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hudsonci.inject.SmoothieContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.inject.BeanEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named(value="smoothie")
@Singleton
public class SmoothieComponentProviderFactory
implements IoCComponentProviderFactory {
    private static final Logger log = LoggerFactory.getLogger(SmoothieComponentProviderFactory.class);
    private final SmoothieContainer container;

    @Inject
    public SmoothieComponentProviderFactory(SmoothieContainer container) {
        this.container = (SmoothieContainer)Preconditions.checkNotNull((Object)container);
    }

    public IoCComponentProvider getComponentProvider(Class<?> type) {
        Preconditions.checkNotNull(type);
        log.trace("Get component provider: {}", type);
        Iterator iter = this.container.locate(Key.get(type)).iterator();
        if (iter.hasNext()) {
            final BeanEntry entry = (BeanEntry)iter.next();
            log.trace("Found component: {}", (Object)entry);
            return new IoCInstantiatedComponentProvider(){

                public Object getInjectableInstance(Object obj) {
                    return obj;
                }

                public Object getInstance() {
                    return entry.getValue();
                }
            };
        }
        return null;
    }

    public IoCComponentProvider getComponentProvider(ComponentContext context, Class<?> type) {
        return this.getComponentProvider(type);
    }
}

