/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.rest.server.internal.jersey;

import com.google.common.base.Preconditions;
import com.sun.jersey.api.core.DefaultResourceConfig;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProviderFactory;
import com.sun.jersey.spi.container.ContainerListener;
import com.sun.jersey.spi.container.ContainerNotifier;
import com.sun.jersey.spi.container.WebApplication;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import com.sun.jersey.spi.container.servlet.WebConfig;
import com.sun.jersey.spi.container.servlet.WebServletConfig;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import org.hudsonci.rest.api.Version;
import org.hudsonci.utils.common.Varargs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestServlet
extends ServletContainer
implements ContainerNotifier {
    private static final Logger log = LoggerFactory.getLogger(RestServlet.class);
    private static final long serialVersionUID = 1L;
    private final List<Application> deferredApplications = new ArrayList<Application>();
    private final List<ContainerListener> listeners = new ArrayList<ContainerListener>();
    private final IoCComponentProviderFactory componentProviderFactory;
    private ResourceConfig resourceConfig;

    public RestServlet(IoCComponentProviderFactory componentProviderFactory) {
        this.componentProviderFactory = (IoCComponentProviderFactory)Preconditions.checkNotNull((Object)componentProviderFactory);
    }

    protected ResourceConfig getDefaultResourceConfig(Map<String, Object> props, WebConfig webConfig) throws ServletException {
        DefaultResourceConfig config = new DefaultResourceConfig();
        config.getSingletons().add(new DummyResource());
        return config;
    }

    protected synchronized void initiate(ResourceConfig config, WebApplication webApp) {
        this.resourceConfig = (ResourceConfig)Preconditions.checkNotNull((Object)config);
        webApp.initiate(config, this.componentProviderFactory);
        while (this.deferredApplications.size() > 0) {
            this.resourceConfig.add(this.deferredApplications.remove(0));
            for (ContainerListener listener : this.listeners) {
                listener.onReload();
            }
        }
    }

    public void init() throws ServletException {
        this.init((WebConfig)new WebServletConfig(this){

            public ResourceConfig getDefaultResourceConfig(Map<String, Object> props) throws ServletException {
                Preconditions.checkNotNull(props);
                props.put("com.sun.jersey.spi.container.ContainerNotifier", (Object)RestServlet.this);
                try {
                    return super.getDefaultResourceConfig(props);
                }
                catch (LinkageError e) {
                    return RestServlet.this.getDefaultResourceConfig(props, RestServlet.this.getServletConfig());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        assert (request != null);
        assert (response != null);
        String uri = request.getRequestURI();
        if (request.getQueryString() != null) {
            uri = String.format("%s?%s", uri, request.getQueryString());
        }
        if (log.isDebugEnabled()) {
            log.debug("Processing: {} {} ({}) [{}]", Varargs.$((Object[])new Serializable[]{request.getMethod(), uri, request.getRequestURL(), request.getHeader("X-Hudson")}));
        }
        MDC.put((String)((Object)((Object)this)).getClass().getName(), (String)uri);
        try {
            super.service(request, response);
        }
        finally {
            MDC.remove((String)((Object)((Object)this)).getClass().getName());
        }
        response.addHeader("X-Hudson", String.format("api=%s", this.getApiVersion()));
    }

    private String getApiVersion() {
        return Version.get().getVersion();
    }

    public synchronized void addApplication(Application application) {
        Preconditions.checkNotNull((Object)application);
        if (this.resourceConfig != null) {
            this.resourceConfig.add(application);
            for (ContainerListener listener : this.listeners) {
                listener.onReload();
            }
        } else {
            this.deferredApplications.add(application);
        }
    }

    public synchronized void addListener(ContainerListener listener) {
        Preconditions.checkNotNull((Object)listener);
        this.listeners.add(listener);
    }

    @Path(value="/internal/dummy-root-resource-for-jersey")
    private static class DummyResource {
    }
}

