/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import hudson.FilePath;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.jvnet.hudson.test.TestEnvironment;

public interface HudsonHomeLoader {
    public static final HudsonHomeLoader NEW = new HudsonHomeLoader(){

        public File allocate() throws IOException {
            return TestEnvironment.get().temporaryDirectoryAllocator.allocate();
        }
    };

    public File allocate() throws Exception;

    public static class CopyExisting
    implements HudsonHomeLoader {
        private final File source;

        public CopyExisting(File source) {
            if (source == null) {
                throw new IllegalArgumentException();
            }
            this.source = source;
        }

        public CopyExisting(URL source) {
            if (!source.getProtocol().equals("file")) {
                throw new UnsupportedOperationException("Unsupported protocol: " + source);
            }
            this.source = new File(source.getPath());
        }

        public File allocate() throws Exception {
            File target = NEW.allocate();
            if (this.source.isDirectory()) {
                new FilePath(this.source).copyRecursiveTo("**/*", new FilePath(target));
            } else if (this.source.getName().endsWith(".zip")) {
                new FilePath(this.source).unzip(new FilePath(target));
            }
            return target;
        }
    }
}

