/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import com.gargoylesoftware.htmlunit.html.HtmlPage;
import hudson.model.FreeStyleProject;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.TopLevelItemDescriptor;
import java.io.File;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import junit.framework.TestCase;
import org.jvnet.hudson.test.HudsonHomeLoader;
import org.jvnet.hudson.test.TestEnvironment;
import org.kohsuke.stapler.Stapler;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.xml.sax.SAXException;

public abstract class HudsonTestCase
extends TestCase {
    protected Hudson hudson;
    protected final TestEnvironment env = new TestEnvironment();
    protected HudsonHomeLoader homeLoader;
    protected int localPort;
    protected Server server;
    protected String contextPath = "/";

    protected HudsonTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.env.pin();
        this.recipe();
        this.hudson = this.newHudson();
        this.hudson.servletContext.setAttribute("app", (Object)this.hudson);
    }

    protected void tearDown() throws Exception {
        this.hudson.cleanUp();
        this.env.dispose();
        this.server.stop();
    }

    protected Hudson newHudson() throws Exception {
        return new Hudson(this.homeLoader.allocate(), this.createWebServer());
    }

    protected ServletContext createWebServer() throws Exception {
        this.server = new Server();
        Context root = new Context((HandlerContainer)this.server, this.contextPath, 1);
        ServletHolder holder = new ServletHolder((Servlet)new Stapler());
        root.addServlet(holder, "/");
        SocketConnector connector = new SocketConnector();
        this.server.addConnector((Connector)connector);
        this.server.start();
        this.localPort = connector.getLocalPort();
        return holder.getServletHandler().getServletContext();
    }

    protected FreeStyleProject createFreeStyleProject() throws IOException {
        return this.createFreeStyleProject("test");
    }

    protected FreeStyleProject createFreeStyleProject(String name) throws IOException {
        return (FreeStyleProject)this.hudson.createProject((TopLevelItemDescriptor)FreeStyleProject.DESCRIPTOR, name);
    }

    protected void recipe() {
        this.withNewHome();
    }

    protected HudsonTestCase withNewHome() {
        this.homeLoader = HudsonHomeLoader.NEW;
        return this;
    }

    protected HudsonTestCase withExistingHome(File source) {
        this.homeLoader = new HudsonHomeLoader.CopyExisting(source);
        return this;
    }

    public class WebClient
    extends com.gargoylesoftware.htmlunit.WebClient {
        public WebClient() {
            this.setJavaScriptEnabled(false);
        }

        public HtmlPage getPage(Item item) throws IOException, SAXException {
            return (HtmlPage)this.getPage("http://localhost:" + HudsonTestCase.this.localPort + HudsonTestCase.this.contextPath + item.getUrl());
        }
    }
}

