/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.PageCreator;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import hudson.model.FreeStyleProject;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.TopLevelItemDescriptor;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletContext;
import junit.framework.TestCase;
import org.jvnet.hudson.test.HudsonHomeLoader;
import org.jvnet.hudson.test.HudsonPageCreator;
import org.jvnet.hudson.test.LenientRunnable;
import org.jvnet.hudson.test.NoListenerConfiguration;
import org.jvnet.hudson.test.TestEnvironment;
import org.jvnet.hudson.test.WarExploder;
import org.jvnet.hudson.test.recipes.Recipe;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.security.HashUserRealm;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.jetty.webapp.Configuration;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.jetty.webapp.WebXmlConfiguration;
import org.xml.sax.SAXException;

public abstract class HudsonTestCase
extends TestCase {
    protected Hudson hudson;
    protected final TestEnvironment env = new TestEnvironment();
    protected HudsonHomeLoader homeLoader = HudsonHomeLoader.NEW;
    protected int localPort;
    protected Server server;
    protected String contextPath = "/";
    protected List<LenientRunnable> tearDowns = new ArrayList<LenientRunnable>();

    protected HudsonTestCase(String name) {
        super(name);
    }

    protected HudsonTestCase() {
    }

    protected void setUp() throws Exception {
        this.env.pin();
        this.recipe();
        this.hudson = this.newHudson();
        this.hudson.servletContext.setAttribute("app", (Object)this.hudson);
        this.hudson.servletContext.setAttribute("version", (Object)"?");
    }

    protected void tearDown() throws Exception {
        for (LenientRunnable r : this.tearDowns) {
            r.run();
        }
        this.hudson.cleanUp();
        this.env.dispose();
        this.server.stop();
    }

    protected Hudson newHudson() throws Exception {
        return new Hudson(this.homeLoader.allocate(), this.createWebServer());
    }

    protected ServletContext createWebServer() throws Exception {
        this.server = new Server();
        WebAppContext context = new WebAppContext(WarExploder.EXPLODE_DIR.getPath(), this.contextPath);
        context.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        context.setConfigurations(new Configuration[]{new WebXmlConfiguration(), new NoListenerConfiguration()});
        this.server.setHandler((Handler)context);
        SocketConnector connector = new SocketConnector();
        this.server.addConnector((Connector)connector);
        this.server.addUserRealm(this.configureUserRealm());
        this.server.start();
        this.localPort = connector.getLocalPort();
        return context.getServletContext();
    }

    protected UserRealm configureUserRealm() {
        HashUserRealm realm = new HashUserRealm();
        realm.setName("default");
        realm.put((Object)"alice", (Object)"alice");
        realm.put((Object)"bob", (Object)"bob");
        realm.put((Object)"charlie", (Object)"charlie");
        realm.addUserToRole("alice", "female");
        realm.addUserToRole("bob", "male");
        realm.addUserToRole("charlie", "male");
        return realm;
    }

    protected FreeStyleProject createFreeStyleProject() throws IOException {
        return this.createFreeStyleProject("test");
    }

    protected FreeStyleProject createFreeStyleProject(String name) throws IOException {
        return (FreeStyleProject)this.hudson.createProject((TopLevelItemDescriptor)FreeStyleProject.DESCRIPTOR, name);
    }

    protected void recipe() throws Exception {
        Method runMethod = ((Object)((Object)this)).getClass().getMethod(this.getName(), new Class[0]);
        for (final Annotation a : runMethod.getAnnotations()) {
            Recipe r = a.annotationType().getAnnotation(Recipe.class);
            if (r == null) continue;
            final Recipe.Runner runner = r.value().newInstance();
            this.tearDowns.add(new LenientRunnable(){

                public void run() throws Exception {
                    runner.tearDown(HudsonTestCase.this, a);
                }
            });
            runner.setup(this, a);
        }
    }

    public HudsonTestCase withNewHome() {
        this.homeLoader = HudsonHomeLoader.NEW;
        return this;
    }

    public HudsonTestCase withExistingHome(File source) {
        this.homeLoader = new HudsonHomeLoader.CopyExisting(source);
        return this;
    }

    public HudsonTestCase withPresetData(String name) {
        name = "/" + name + ".zip";
        URL res = ((Object)((Object)this)).getClass().getResource(name);
        if (res == null) {
            throw new IllegalArgumentException("No such data set found: " + name);
        }
        this.homeLoader = new HudsonHomeLoader.CopyExisting(res);
        return this;
    }

    static {
        Locale.setDefault(Locale.ENGLISH);
    }

    public class WebClient
    extends com.gargoylesoftware.htmlunit.WebClient {
        public WebClient() {
            this.setJavaScriptEnabled(false);
            this.setPageCreator((PageCreator)HudsonPageCreator.INSTANCE);
        }

        public WebClient login(String username, String password) throws Exception {
            HtmlPage page = this.goTo("login");
            HtmlForm form = page.getFormByName("login");
            form.getInputByName("j_username").setValueAttribute(username);
            form.getInputByName("j_password").setValueAttribute(password);
            form.submit(null);
            return this;
        }

        public WebClient login(String username) throws Exception {
            this.login(username, username);
            return this;
        }

        public HtmlPage getPage(Item item) throws IOException, SAXException {
            return this.getPage(item, "");
        }

        public HtmlPage getPage(Item item, String relative) throws IOException, SAXException {
            return this.goTo(item.getUrl() + relative);
        }

        public Page getPage(String url) throws IOException, FailingHttpStatusCodeException {
            return super.getPage(url);
        }

        public HtmlPage goTo(String relative) throws IOException, SAXException {
            return (HtmlPage)this.goTo(relative, "text/html");
        }

        public Page goTo(String relative, String expectedContentType) throws IOException, SAXException {
            return super.getPage("http://localhost:" + HudsonTestCase.this.localPort + HudsonTestCase.this.contextPath + relative);
        }
    }
}

