/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import hudson.FilePath;
import hudson.remoting.Which;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;

final class WarExploder {
    public static final File EXPLODE_DIR = WarExploder.explode();

    WarExploder() {
    }

    private static File explode() {
        try {
            File dir;
            File p;
            File d;
            for (d = new File(".").getAbsoluteFile(); !(d == null || d.getName().equals("main") && (p = d.getParentFile()) != null && p.getName().equals("hudson")); d = d.getParentFile()) {
            }
            if (d != null && (dir = new File(d, "war/target/hudson")).exists()) {
                System.out.println("Using hudson.war resources from " + dir);
                return dir;
            }
            URL winstone = WarExploder.class.getResource("/winstone.jar");
            if (winstone == null) {
                throw new AssertionError((Object)"hudson.war is not in the classpath.");
            }
            File war = Which.jarFile(Class.forName("executable.Executable"));
            File explodeDir = new File("./target/hudson-for-test");
            File timestamp = new File(explodeDir, ".timestamp");
            if (!timestamp.exists() || timestamp.lastModified() != war.lastModified()) {
                System.out.println("Exploding hudson.war at " + war);
                new FilePath(explodeDir).deleteRecursive();
                new FilePath(war).unzip(new FilePath(explodeDir));
                new FileOutputStream(timestamp).close();
                timestamp.setLastModified(war.lastModified());
            } else {
                System.out.println("Picking up existing exploded hudson.war at " + explodeDir.getAbsolutePath());
            }
            return explodeDir;
        }
        catch (IOException e) {
            throw new Error(e);
        }
        catch (InterruptedException e) {
            throw new Error(e);
        }
        catch (ClassNotFoundException e) {
            throw new Error(e);
        }
    }
}

