/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import com.gargoylesoftware.htmlunit.AjaxController;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.PageCreator;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.host.Stylesheet;
import hudson.Launcher;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.model.TopLevelItemDescriptor;
import hudson.model.UpdateCenter;
import hudson.tasks.Mailer;
import hudson.util.ProcessTreeKiller;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import junit.framework.TestCase;
import org.jvnet.hudson.test.HudsonHomeLoader;
import org.jvnet.hudson.test.HudsonPageCreator;
import org.jvnet.hudson.test.LenientRunnable;
import org.jvnet.hudson.test.NoListenerConfiguration;
import org.jvnet.hudson.test.TestEnvironment;
import org.jvnet.hudson.test.WarExploder;
import org.jvnet.hudson.test.recipes.Recipe;
import org.jvnet.hudson.test.rhino.JavaScriptDebugger;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.security.HashUserRealm;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.jetty.webapp.Configuration;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.jetty.webapp.WebXmlConfiguration;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.debug.Debugger;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.ErrorHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HudsonTestCase
extends TestCase {
    protected Hudson hudson;
    protected final TestEnvironment env = new TestEnvironment();
    protected HudsonHomeLoader homeLoader = HudsonHomeLoader.NEW;
    protected int localPort;
    protected Server server;
    protected String contextPath = "/";
    protected List<LenientRunnable> tearDowns = new ArrayList<LenientRunnable>();
    private List<WeakReference<WebClient>> clients = new ArrayList<WeakReference<WebClient>>();
    protected JavaScriptDebugger jsDebugger = new JavaScriptDebugger();
    private static final Logger LOGGER;

    protected HudsonTestCase(String name) {
        super(name);
    }

    protected HudsonTestCase() {
    }

    protected void setUp() throws Exception {
        this.env.pin();
        this.recipe();
        this.hudson = this.newHudson();
        this.hudson.servletContext.setAttribute("app", (Object)this.hudson);
        this.hudson.servletContext.setAttribute("version", (Object)"?");
        Mailer.DESCRIPTOR.setHudsonUrl(null);
        for (Descriptor d : Descriptor.ALL) {
            d.load();
        }
    }

    protected void tearDown() throws Exception {
        for (WeakReference<WebClient> client : this.clients) {
            WebClient c = (WebClient)((Object)client.get());
            if (c == null) continue;
            c.getPage("about:blank");
        }
        this.clients.clear();
        this.server.stop();
        for (LenientRunnable r : this.tearDowns) {
            r.run();
        }
        this.hudson.cleanUp();
        this.env.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTest() throws Throwable {
        new JavaScriptEngine(null);
        Context cx = ContextFactory.getGlobal().enterContext();
        try {
            cx.setOptimizationLevel(-1);
            cx.setDebugger((Debugger)this.jsDebugger, null);
            super.runTest();
        }
        finally {
            Context.exit();
        }
    }

    protected Hudson newHudson() throws Exception {
        return new Hudson(this.homeLoader.allocate(), this.createWebServer());
    }

    protected ServletContext createWebServer() throws Exception {
        this.server = new Server();
        WebAppContext context = new WebAppContext(WarExploder.EXPLODE_DIR.getPath(), this.contextPath);
        context.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        context.setConfigurations(new Configuration[]{new WebXmlConfiguration(), new NoListenerConfiguration()});
        this.server.setHandler((Handler)context);
        SocketConnector connector = new SocketConnector();
        this.server.addConnector((Connector)connector);
        this.server.addUserRealm(this.configureUserRealm());
        this.server.start();
        this.localPort = connector.getLocalPort();
        return context.getServletContext();
    }

    protected UserRealm configureUserRealm() {
        HashUserRealm realm = new HashUserRealm();
        realm.setName("default");
        realm.put((Object)"alice", (Object)"alice");
        realm.put((Object)"bob", (Object)"bob");
        realm.put((Object)"charlie", (Object)"charlie");
        realm.addUserToRole("alice", "female");
        realm.addUserToRole("bob", "male");
        realm.addUserToRole("charlie", "male");
        return realm;
    }

    protected FreeStyleProject createFreeStyleProject() throws IOException {
        return this.createFreeStyleProject("test");
    }

    protected FreeStyleProject createFreeStyleProject(String name) throws IOException {
        return (FreeStyleProject)this.hudson.createProject((TopLevelItemDescriptor)FreeStyleProject.DESCRIPTOR, name);
    }

    protected Launcher.LocalLauncher createLocalLauncher() {
        return new Launcher.LocalLauncher((TaskListener)new StreamTaskListener(System.out));
    }

    protected <T> T last(List<T> items) {
        return items.get(items.size() - 1);
    }

    protected void recipe() throws Exception {
        Method runMethod = ((Object)((Object)this)).getClass().getMethod(this.getName(), new Class[0]);
        for (final Annotation a : runMethod.getAnnotations()) {
            Recipe r = a.annotationType().getAnnotation(Recipe.class);
            if (r == null) continue;
            final Recipe.Runner runner = r.value().newInstance();
            this.tearDowns.add(new LenientRunnable(){

                public void run() throws Exception {
                    runner.tearDown(HudsonTestCase.this, a);
                }
            });
            runner.setup(this, a);
        }
    }

    public HudsonTestCase withNewHome() {
        return this.with(HudsonHomeLoader.NEW);
    }

    public HudsonTestCase withExistingHome(File source) {
        return this.with(new HudsonHomeLoader.CopyExisting(source));
    }

    public HudsonTestCase withPresetData(String name) {
        name = "/" + name + ".zip";
        URL res = ((Object)((Object)this)).getClass().getResource(name);
        if (res == null) {
            throw new IllegalArgumentException("No such data set found: " + name);
        }
        return this.with(new HudsonHomeLoader.CopyExisting(res));
    }

    public HudsonTestCase with(HudsonHomeLoader homeLoader) {
        this.homeLoader = homeLoader;
        return this;
    }

    private Object writeReplace() {
        throw new AssertionError((Object)("HudsonTestCase " + this.getName() + " is not supposed to be serialized"));
    }

    static {
        Locale.setDefault(Locale.ENGLISH);
        UpdateCenter.neverUpdate = true;
        final ErrorHandler defaultHandler = Stylesheet.CSS_ERROR_HANDLER;
        Stylesheet.CSS_ERROR_HANDLER = new ErrorHandler(){

            public void warning(CSSParseException exception) throws CSSException {
                if (!this.ignore(exception)) {
                    defaultHandler.warning(exception);
                }
            }

            public void error(CSSParseException exception) throws CSSException {
                if (!this.ignore(exception)) {
                    defaultHandler.error(exception);
                }
            }

            public void fatalError(CSSParseException exception) throws CSSException {
                if (!this.ignore(exception)) {
                    defaultHandler.fatalError(exception);
                }
            }

            private boolean ignore(CSSParseException e) {
                return e.getURI().contains("/yui/");
            }
        };
        ProcessTreeKiller.enabled = true;
        Logger.getLogger("org.springframework").setLevel(Level.WARNING);
        System.setProperty("hudson.unitTest", "true");
        LOGGER = Logger.getLogger(HudsonTestCase.class.getName());
    }

    public class WebClient
    extends com.gargoylesoftware.htmlunit.WebClient {
        public WebClient() {
            this.setPageCreator((PageCreator)HudsonPageCreator.INSTANCE);
            HudsonTestCase.this.clients.add(new WeakReference<WebClient>(this));
            this.setAjaxController(new AjaxController(){

                public boolean processSynchron(HtmlPage page, WebRequestSettings settings, boolean async) {
                    return true;
                }
            });
        }

        public WebClient login(String username, String password) throws Exception {
            HtmlPage page = this.goTo("login");
            HtmlForm form = page.getFormByName("login");
            form.getInputByName("j_username").setValueAttribute(username);
            form.getInputByName("j_password").setValueAttribute(password);
            form.submit(null);
            return this;
        }

        public WebClient login(String username) throws Exception {
            this.login(username, username);
            return this;
        }

        public HtmlPage getPage(Item item) throws IOException, SAXException {
            return this.getPage(item, "");
        }

        public HtmlPage getPage(Item item, String relative) throws IOException, SAXException {
            return this.goTo(item.getUrl() + relative);
        }

        public Page getPage(String url) throws IOException, FailingHttpStatusCodeException {
            return super.getPage(url);
        }

        public HtmlPage goTo(String relative) throws IOException, SAXException {
            return (HtmlPage)this.goTo(relative, "text/html");
        }

        public Page goTo(String relative, String expectedContentType) throws IOException, SAXException {
            return super.getPage("http://localhost:" + HudsonTestCase.this.localPort + HudsonTestCase.this.contextPath + relative);
        }
    }
}

