/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import hudson.FilePath;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import org.jvnet.hudson.test.TestEnvironment;

public interface HudsonHomeLoader {
    public static final HudsonHomeLoader NEW = new HudsonHomeLoader(){

        public File allocate() throws IOException {
            return TestEnvironment.get().temporaryDirectoryAllocator.allocate();
        }
    };

    public File allocate() throws Exception;

    public static final class Local
    implements HudsonHomeLoader {
        private final Method testMethod;
        private static final String[] SUFFIXES = new String[]{"/config.xml", ".zip"};

        public Local(Method testMethod) {
            this.testMethod = testMethod;
        }

        public File allocate() throws Exception {
            URL res = this.findDataResource();
            if (!res.getProtocol().equals("file")) {
                throw new AssertionError((Object)("Test data is not available in the file system: " + res));
            }
            File home = new File(res.getPath());
            if (!home.getName().endsWith(".zip")) {
                home = home.getParentFile();
            }
            return new CopyExisting(home).allocate();
        }

        private URL findDataResource() {
            Class<?> clazz = this.testMethod.getDeclaringClass();
            for (String middle : new String[]{'/' + this.testMethod.getName(), ""}) {
                for (String suffix : SUFFIXES) {
                    URL res = clazz.getResource(clazz.getSimpleName() + middle + suffix);
                    if (res == null) continue;
                    return res;
                }
            }
            throw new AssertionError((Object)("No test resource was found for " + this.testMethod));
        }
    }

    public static final class CopyExisting
    implements HudsonHomeLoader {
        private final File source;

        public CopyExisting(File source) {
            if (source == null) {
                throw new IllegalArgumentException();
            }
            this.source = source;
        }

        public CopyExisting(URL source) {
            if (!source.getProtocol().equals("file")) {
                throw new UnsupportedOperationException("Unsupported protocol: " + source);
            }
            this.source = new File(source.getPath());
        }

        public File allocate() throws Exception {
            File target = NEW.allocate();
            if (this.source.isDirectory()) {
                new FilePath(this.source).copyRecursiveTo("**/*", new FilePath(target));
            } else if (this.source.getName().endsWith(".zip")) {
                new FilePath(this.source).unzip(new FilePath(target));
            }
            return target;
        }
    }
}

