/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import com.gargoylesoftware.htmlunit.AjaxController;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.PageCreator;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.host.Stylesheet;
import com.gargoylesoftware.htmlunit.javascript.host.XMLHttpRequest;
import hudson.CloseProofOutputStream;
import hudson.FilePath;
import hudson.Functions;
import hudson.Launcher;
import hudson.WebAppMain;
import hudson.matrix.MatrixProject;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenReporters;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.JDK;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.TopLevelItemDescriptor;
import hudson.model.UpdateCenter;
import hudson.slaves.CommandLauncher;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.DumbSlave;
import hudson.slaves.RetentionStrategy;
import hudson.tasks.BuildStep;
import hudson.tasks.Mailer;
import hudson.tasks.Maven;
import hudson.util.ProcessTreeKiller;
import hudson.util.StreamTaskListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.jar.Manifest;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jvnet.hudson.test.HudsonHomeLoader;
import org.jvnet.hudson.test.HudsonPageCreator;
import org.jvnet.hudson.test.LenientRunnable;
import org.jvnet.hudson.test.NoListenerConfiguration;
import org.jvnet.hudson.test.TestEnvironment;
import org.jvnet.hudson.test.WarExploder;
import org.jvnet.hudson.test.recipes.Recipe;
import org.jvnet.hudson.test.rhino.JavaScriptDebugger;
import org.kohsuke.stapler.Dispatcher;
import org.kohsuke.stapler.MetaClass;
import org.kohsuke.stapler.MetaClassLoader;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.security.HashUserRealm;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.jetty.webapp.Configuration;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.jetty.webapp.WebXmlConfiguration;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.debug.Debugger;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.ErrorHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HudsonTestCase
extends TestCase {
    public Hudson hudson;
    protected final TestEnvironment env = new TestEnvironment();
    protected HudsonHomeLoader homeLoader = HudsonHomeLoader.NEW;
    protected int localPort;
    protected Server server;
    protected String contextPath = "/";
    protected List<LenientRunnable> tearDowns = new ArrayList<LenientRunnable>();
    protected List<Recipe.Runner> recipes = new ArrayList<Recipe.Runner>();
    private List<WeakReference<WebClient>> clients = new ArrayList<WeakReference<WebClient>>();
    protected JavaScriptDebugger jsDebugger = new JavaScriptDebugger();
    private static final Logger XML_HTTP_REQUEST_LOGGER = Logger.getLogger(XMLHttpRequest.class.getName());
    private static final Logger LOGGER;

    protected HudsonTestCase(String name) {
        super(name);
    }

    protected HudsonTestCase() {
    }

    protected void setUp() throws Exception {
        this.env.pin();
        this.recipe();
        this.hudson = this.newHudson();
        this.hudson.setNoUsageStatistics(Boolean.valueOf(true));
        this.hudson.servletContext.setAttribute("app", (Object)this.hudson);
        this.hudson.servletContext.setAttribute("version", (Object)"?");
        WebAppMain.installExpressionFactory((ServletContextEvent)new ServletContextEvent(this.hudson.servletContext));
        this.hudson.getJDKs().add(new JDK("default", System.getProperty("java.home")));
        Mailer.DESCRIPTOR.setHudsonUrl(null);
        for (Descriptor d : Descriptor.ALL) {
            d.load();
        }
    }

    protected void tearDown() throws Exception {
        for (WeakReference<WebClient> client : this.clients) {
            WebClient c = (WebClient)((Object)client.get());
            if (c == null) continue;
            c.getPage("about:blank");
        }
        this.clients.clear();
        this.server.stop();
        for (LenientRunnable r : this.tearDowns) {
            r.run();
        }
        this.cleanUpDescriptors((Iterable<? extends Descriptor>)Descriptor.ALL);
        this.cleanUpDescriptors((Iterable<? extends Descriptor>)BuildStep.PUBLISHERS);
        this.cleanUpDescriptors(MavenReporters.LIST);
        this.hudson.cleanUp();
        this.env.dispose();
    }

    private void cleanUpDescriptors(Iterable<? extends Descriptor> cont) {
        ClassLoader base = ((Object)((Object)this)).getClass().getClassLoader();
        Iterator<? extends Descriptor> itr = cont.iterator();
        block0: while (itr.hasNext()) {
            Descriptor d = itr.next();
            ClassLoader cl = d.getClass().getClassLoader();
            if (cl == base) continue;
            while (cl != null) {
                if ((cl = cl.getParent()) != base) continue;
                itr.remove();
                continue block0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTest() throws Throwable {
        System.out.println("=== Starting " + this.getName());
        new JavaScriptEngine(null);
        Context cx = ContextFactory.getGlobal().enterContext();
        try {
            cx.setOptimizationLevel(-1);
            cx.setDebugger((Debugger)this.jsDebugger, null);
            super.runTest();
        }
        finally {
            Context.exit();
        }
    }

    protected Hudson newHudson() throws Exception {
        File home = this.homeLoader.allocate();
        for (Recipe.Runner r : this.recipes) {
            r.decorateHome(this, home);
        }
        return new Hudson(home, this.createWebServer());
    }

    protected ServletContext createWebServer() throws Exception {
        this.server = new Server();
        WebAppContext context = new WebAppContext(WarExploder.getExplodedDir().getPath(), this.contextPath);
        context.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        context.setConfigurations(new Configuration[]{new WebXmlConfiguration(), new NoListenerConfiguration()});
        this.server.setHandler((Handler)context);
        SocketConnector connector = new SocketConnector();
        this.server.addConnector((Connector)connector);
        this.server.addUserRealm(this.configureUserRealm());
        this.server.start();
        this.localPort = connector.getLocalPort();
        return context.getServletContext();
    }

    protected UserRealm configureUserRealm() {
        HashUserRealm realm = new HashUserRealm();
        realm.setName("default");
        realm.put((Object)"alice", (Object)"alice");
        realm.put((Object)"bob", (Object)"bob");
        realm.put((Object)"charlie", (Object)"charlie");
        realm.addUserToRole("alice", "female");
        realm.addUserToRole("bob", "male");
        realm.addUserToRole("charlie", "male");
        return realm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configureDefaultMaven() throws Exception {
        String home = System.getProperty("maven.home");
        if (home != null) {
            Maven.DESCRIPTOR.setInstallations(new Maven.MavenInstallation[]{new Maven.MavenInstallation("default", home)});
            return;
        }
        LOGGER.warning("Extracting a copy of Maven bundled in the test harness. To avoid a performance hit, set the system property 'maven.home' to point to a Maven2 installation.");
        FilePath mvn = this.hudson.getRootPath().createTempFile("maven", "zip");
        OutputStream os = mvn.write();
        try {
            IOUtils.copy((InputStream)HudsonTestCase.class.getClassLoader().getResourceAsStream("maven-2.0.7-bin.zip"), (OutputStream)os);
        }
        finally {
            os.close();
        }
        File mvnHome = this.createTmpDir();
        mvn.unzip(new FilePath(mvnHome));
        Maven.DESCRIPTOR.setInstallations(new Maven.MavenInstallation[]{new Maven.MavenInstallation("default", new File(mvnHome, "maven-2.0.7").getAbsolutePath())});
    }

    protected FreeStyleProject createFreeStyleProject() throws IOException {
        return this.createFreeStyleProject(this.createUniqueProjectName());
    }

    protected FreeStyleProject createFreeStyleProject(String name) throws IOException {
        return (FreeStyleProject)this.hudson.createProject((TopLevelItemDescriptor)FreeStyleProject.DESCRIPTOR, name);
    }

    protected MatrixProject createMatrixProject() throws IOException {
        return this.createMatrixProject(this.createUniqueProjectName());
    }

    protected MatrixProject createMatrixProject(String name) throws IOException {
        return (MatrixProject)this.hudson.createProject((TopLevelItemDescriptor)MatrixProject.DESCRIPTOR, name);
    }

    protected MavenModuleSet createMavenProject() throws IOException {
        return this.createMavenProject(this.createUniqueProjectName());
    }

    protected MavenModuleSet createMavenProject(String name) throws IOException {
        return (MavenModuleSet)this.hudson.createProject((TopLevelItemDescriptor)MavenModuleSet.DESCRIPTOR, name);
    }

    private String createUniqueProjectName() {
        return "test" + this.hudson.getItems().size();
    }

    protected Launcher.LocalLauncher createLocalLauncher() {
        return new Launcher.LocalLauncher((TaskListener)new StreamTaskListener(System.out));
    }

    public File createTmpDir() throws IOException {
        return this.env.temporaryDirectoryAllocator.allocate();
    }

    public DumbSlave createSlave() throws Exception {
        return this.createSlave(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DumbSlave createSlave(Label l) throws Exception {
        CommandLauncher launcher = new CommandLauncher(System.getProperty("java.home") + "/bin/java -jar " + new File(this.hudson.getJnlpJars("slave.jar").getURL().getPath()).getPath());
        Hudson hudson = this.hudson;
        synchronized (hudson) {
            DumbSlave slave = new DumbSlave("slave" + this.hudson.getNodes().size(), "dummy", this.createTmpDir().getPath(), "1", Node.Mode.NORMAL, l == null ? "" : l.getName(), (ComputerLauncher)launcher, RetentionStrategy.NOOP);
            this.hudson.addNode((Node)slave);
            return slave;
        }
    }

    protected <T> T last(List<T> items) {
        return items.get(items.size() - 1);
    }

    protected void pause() throws IOException {
        new BufferedReader(new InputStreamReader(System.in)).readLine();
    }

    protected Page search(String q) throws Exception {
        HtmlPage top = new WebClient().goTo("");
        HtmlForm search = top.getFormByName("search");
        search.getInputByName("q").setValueAttribute(q);
        return search.submit(null);
    }

    public <R extends Run> R assertBuildStatus(Result status, R r) throws Exception {
        if (status == r.getResult()) {
            return r;
        }
        System.out.println(r.getLog());
        HudsonTestCase.assertEquals((Object)status, (Object)r.getResult());
        return r;
    }

    public <R extends Run> R assertBuildStatusSuccess(R r) throws Exception {
        this.assertBuildStatus(Result.SUCCESS, r);
        return r;
    }

    public void assertLogContains(String substring, Run run) throws Exception {
        String log = run.getLog();
        if (log.contains(substring)) {
            return;
        }
        System.out.println(log);
        HudsonTestCase.fail((String)("Console output of " + run + " didn't contain " + substring));
    }

    public void assertXPath(HtmlPage page, String xpath) {
        HudsonTestCase.assertNotNull((String)("There should be an object that matches XPath:" + xpath), (Object)page.getDocumentElement().selectSingleNode(xpath));
    }

    public HtmlPage submit(HtmlForm form) throws Exception {
        return (HtmlPage)form.submit((SubmittableElement)((HtmlButton)this.last(form.getHtmlElementsByTagName("button"))));
    }

    public TaskListener createTaskListener() {
        return new StreamTaskListener((OutputStream)new CloseProofOutputStream((OutputStream)System.out));
    }

    protected void recipe() throws Exception {
        this.recipeLoadCurrentPlugin();
        Method runMethod = ((Object)((Object)this)).getClass().getMethod(this.getName(), new Class[0]);
        for (final Annotation a : runMethod.getAnnotations()) {
            Recipe r = a.annotationType().getAnnotation(Recipe.class);
            if (r == null) continue;
            final Recipe.Runner runner = r.value().newInstance();
            this.recipes.add(runner);
            this.tearDowns.add(new LenientRunnable(){

                public void run() throws Exception {
                    runner.tearDown(HudsonTestCase.this, a);
                }
            });
            runner.setup(this, a);
        }
    }

    protected void recipeLoadCurrentPlugin() throws Exception {
        Enumeration<URL> e = ((Object)((Object)this)).getClass().getClassLoader().getResources("the.hpl");
        if (!e.hasMoreElements()) {
            return;
        }
        final URL hpl = e.nextElement();
        if (e.hasMoreElements()) {
            URL hpl2 = e.nextElement();
            throw new Error("We have both " + hpl + " and " + hpl2);
        }
        this.recipes.add(new Recipe.Runner(){

            public void decorateHome(HudsonTestCase testCase, File home) throws Exception {
                Manifest m = new Manifest(hpl.openStream());
                String shortName = m.getMainAttributes().getValue("Short-Name");
                if (shortName == null) {
                    throw new Error(hpl + " doesn't have the Short-Name attribute");
                }
                FileUtils.copyURLToFile((URL)hpl, (File)new File(home, "plugins/" + shortName + ".hpl"));
            }
        });
    }

    public HudsonTestCase withNewHome() {
        return this.with(HudsonHomeLoader.NEW);
    }

    public HudsonTestCase withExistingHome(File source) throws Exception {
        return this.with(new HudsonHomeLoader.CopyExisting(source));
    }

    public HudsonTestCase withPresetData(String name) {
        name = "/" + name + ".zip";
        URL res = ((Object)((Object)this)).getClass().getResource(name);
        if (res == null) {
            throw new IllegalArgumentException("No such data set found: " + name);
        }
        return this.with(new HudsonHomeLoader.CopyExisting(res));
    }

    public HudsonTestCase with(HudsonHomeLoader homeLoader) {
        this.homeLoader = homeLoader;
        return this;
    }

    private Object writeReplace() {
        throw new AssertionError((Object)("HudsonTestCase " + this.getName() + " is not supposed to be serialized"));
    }

    static {
        Locale.setDefault(Locale.ENGLISH);
        UpdateCenter.neverUpdate = true;
        Dispatcher.TRACE = true;
        MetaClass.NO_CACHE = true;
        File dir = new File("src/main/resources");
        if (dir.exists() && MetaClassLoader.debugLoader == null) {
            try {
                MetaClassLoader.debugLoader = new MetaClassLoader((ClassLoader)new URLClassLoader(new URL[]{dir.toURL()}));
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
        }
        final ErrorHandler defaultHandler = Stylesheet.CSS_ERROR_HANDLER;
        Stylesheet.CSS_ERROR_HANDLER = new ErrorHandler(){

            public void warning(CSSParseException exception) throws CSSException {
                if (!this.ignore(exception)) {
                    defaultHandler.warning(exception);
                }
            }

            public void error(CSSParseException exception) throws CSSException {
                if (!this.ignore(exception)) {
                    defaultHandler.error(exception);
                }
            }

            public void fatalError(CSSParseException exception) throws CSSException {
                if (!this.ignore(exception)) {
                    defaultHandler.fatalError(exception);
                }
            }

            private boolean ignore(CSSParseException e) {
                return e.getURI().contains("/yui/");
            }
        };
        ProcessTreeKiller.enabled = true;
        Logger.getLogger("org.springframework").setLevel(Level.WARNING);
        Functions.isUnitTest = true;
        XML_HTTP_REQUEST_LOGGER.setFilter(new Filter(){

            public boolean isLoggable(LogRecord record) {
                return !record.getMessage().contains("XMLHttpRequest.getResponseHeader() was called before the response was available.");
            }
        });
        LOGGER = Logger.getLogger(HudsonTestCase.class.getName());
    }

    public class WebClient
    extends com.gargoylesoftware.htmlunit.WebClient {
        public WebClient() {
            super(BrowserVersion.FIREFOX_2);
            this.setPageCreator((PageCreator)HudsonPageCreator.INSTANCE);
            HudsonTestCase.this.clients.add(new WeakReference<WebClient>(this));
            this.setAjaxController(new AjaxController(){

                public boolean processSynchron(HtmlPage page, WebRequestSettings settings, boolean async) {
                    return true;
                }
            });
        }

        public WebClient login(String username, String password) throws Exception {
            HtmlPage page = this.goTo("login");
            HtmlForm form = page.getFormByName("login");
            form.getInputByName("j_username").setValueAttribute(username);
            form.getInputByName("j_password").setValueAttribute(password);
            form.submit(null);
            return this;
        }

        public WebClient login(String username) throws Exception {
            this.login(username, username);
            return this;
        }

        public HtmlPage getPage(Run r) throws IOException, SAXException {
            return this.getPage(r, "");
        }

        public HtmlPage getPage(Run r, String relative) throws IOException, SAXException {
            return this.goTo(r.getUrl() + relative);
        }

        public HtmlPage getPage(Item item) throws IOException, SAXException {
            return this.getPage(item, "");
        }

        public HtmlPage getPage(Item item, String relative) throws IOException, SAXException {
            return this.goTo(item.getUrl() + relative);
        }

        public Page getPage(String url) throws IOException, FailingHttpStatusCodeException {
            return super.getPage(url);
        }

        public HtmlPage goTo(String relative) throws IOException, SAXException {
            Page p = this.goTo(relative, "text/html");
            if (p instanceof HtmlPage) {
                return (HtmlPage)p;
            }
            throw new AssertionError((Object)("Expected text/html but instead the content type was " + p.getWebResponse().getContentType()));
        }

        public Page goTo(String relative, String expectedContentType) throws IOException, SAXException {
            return super.getPage(this.getContextPath() + relative);
        }

        public String getContextPath() {
            return "http://localhost:" + HudsonTestCase.this.localPort + HudsonTestCase.this.contextPath;
        }
    }
}

