/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import hudson.FilePath;
import hudson.remoting.Which;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;

final class WarExploder {
    private static File EXPLODE_DIR;
    private static Exception FAILURE;

    WarExploder() {
    }

    public static File getExplodedDir() throws Exception {
        if (FAILURE != null) {
            throw new Exception("Failed to initialize exploded war", FAILURE);
        }
        return EXPLODE_DIR;
    }

    private static File explode() throws Exception {
        File dir;
        File d = new File(".").getAbsoluteFile();
        if (new File(d, "main/war/target/hudson").exists()) {
            return new File(d, "main/war/target/hudson");
        }
        while (!(d == null || d.getName().equals("main") && new File(d, ".hudson").exists())) {
            d = d.getParentFile();
        }
        if (d != null && (dir = new File(d, "war/target/hudson")).exists()) {
            System.out.println("Using hudson.war resources from " + dir);
            return dir;
        }
        URL winstone = WarExploder.class.getResource("/winstone.jar");
        if (winstone == null) {
            throw new AssertionError((Object)"hudson.war is not in the classpath.");
        }
        File war = Which.jarFile(Class.forName("executable.Executable"));
        File explodeDir = new File("./target/hudson-for-test").getAbsoluteFile();
        File timestamp = new File(explodeDir, ".timestamp");
        if (!timestamp.exists() || timestamp.lastModified() != war.lastModified()) {
            System.out.println("Exploding hudson.war at " + war);
            new FilePath(explodeDir).deleteRecursive();
            new FilePath(war).unzip(new FilePath(explodeDir));
            if (!explodeDir.exists()) {
                throw new IOException("Failed to explode " + war);
            }
            new FileOutputStream(timestamp).close();
            timestamp.setLastModified(war.lastModified());
        } else {
            System.out.println("Picking up existing exploded hudson.war at " + explodeDir.getAbsolutePath());
        }
        return explodeDir;
    }

    static {
        try {
            EXPLODE_DIR = WarExploder.explode();
        }
        catch (Exception e) {
            FAILURE = e;
        }
    }
}

