/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import hudson.FilePath;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class TemporaryDirectoryAllocator {
    private final Set<File> tmpDirectories = new HashSet<File>();
    private final File base;

    public TemporaryDirectoryAllocator(File base) {
        this.base = base;
    }

    public TemporaryDirectoryAllocator() {
        this(new File(System.getProperty("java.io.tmpdir")));
    }

    public synchronized File allocate() throws IOException {
        File f = File.createTempFile("hudson", "test", this.base);
        f.delete();
        f.mkdirs();
        this.tmpDirectories.add(f);
        return f;
    }

    public synchronized void dispose() throws IOException, InterruptedException {
        for (File dir : this.tmpDirectories) {
            new FilePath(dir).deleteRecursive();
        }
        this.tmpDirectories.clear();
    }

    public synchronized void disposeAsync() {
        final HashSet<File> tbr = new HashSet<File>(this.tmpDirectories);
        this.tmpDirectories.clear();
        new Thread("Disposing " + this.base){

            public void run() {
                try {
                    for (File dir : tbr) {
                        new FilePath(dir).deleteRecursive();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }
}

