/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import java.util.concurrent.Callable;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.apache.commons.io.FileUtils;
import org.jvnet.hudson.test.HudsonTestCase;
import org.jvnet.hudson.test.junit.GroupedTest;
import org.kohsuke.stapler.MetaClassLoader;
import org.kohsuke.stapler.jelly.JellyClassLoaderTearOff;

public class JellyTestSuiteBuilder {
    public static TestSuite build(File res) throws Exception {
        JellyTestSuite ts = new JellyTestSuite();
        JellyClassLoaderTearOff jct = (JellyClassLoaderTearOff)new MetaClassLoader(JellyTestSuiteBuilder.class.getClassLoader()).loadTearOff(JellyClassLoaderTearOff.class);
        if (res.isDirectory()) {
            for (File jelly : FileUtils.listFiles((File)res, (String[])new String[]{"jelly"}, (boolean)true)) {
                ts.addTest((Test)new JellyCheck(jelly.toURI().toURL(), jct));
            }
        }
        if (res.getName().endsWith(".jar")) {
            String jarUrl = res.toURI().toURL().toExternalForm();
            JarFile jf = new JarFile(res);
            Enumeration<JarEntry> e = jf.entries();
            while (e.hasMoreElements()) {
                JarEntry ent = e.nextElement();
                if (!ent.getName().endsWith(".jelly")) continue;
                ts.addTest((Test)new JellyCheck(new URL("jar:" + jarUrl + "!/" + ent.getName()), jct));
            }
            jf.close();
        }
        return ts;
    }

    private static final class JellyTestSuite
    extends GroupedTest {
        HudsonTestCase h = new HudsonTestCase("Jelly test wrapper"){};

        private JellyTestSuite() {
        }

        protected void setUp() throws Exception {
            this.h.setUp();
        }

        protected void tearDown() throws Exception {
            this.h.tearDown();
        }

        private void doTests(TestResult result) throws Exception {
            super.runGroupedTests(result);
        }

        protected void runGroupedTests(final TestResult result) throws Exception {
            this.h.executeOnServer(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    JellyTestSuite.this.doTests(result);
                    return null;
                }
            });
        }
    }

    private static class JellyCheck
    extends TestCase {
        private final URL jelly;
        private final JellyClassLoaderTearOff jct;

        public JellyCheck(URL jelly, JellyClassLoaderTearOff jct) {
            super(jelly.getPath());
            this.jelly = jelly;
            this.jct = jct;
        }

        protected void runTest() throws Exception {
            this.jct.createContext().compileScript(this.jelly);
        }
    }
}

