/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.scm.ChangeLogParser;
import hudson.scm.NullSCM;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jvnet.hudson.test.ExtractChangeLogParser;

public class ExtractResourceWithChangesSCM
extends NullSCM {
    private final URL firstZip;
    private final URL secondZip;

    public ExtractResourceWithChangesSCM(URL firstZip, URL secondZip) {
        if (firstZip == null || secondZip == null) {
            throw new IllegalArgumentException();
        }
        this.firstZip = firstZip;
        this.secondZip = secondZip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changeLogFile) throws IOException, InterruptedException {
        if (workspace.exists()) {
            listener.getLogger().println("Deleting existing workspace " + workspace.getRemote());
            workspace.deleteRecursive();
        }
        listener.getLogger().println("Staging first zip: " + this.firstZip);
        workspace.unzipFrom(this.firstZip.openStream());
        listener.getLogger().println("Staging second zip: " + this.secondZip);
        workspace.unzipFrom(this.secondZip.openStream());
        ZipInputStream zip = new ZipInputStream(this.secondZip.openStream());
        ExtractChangeLogParser.ExtractChangeLogEntry changeLog = new ExtractChangeLogParser.ExtractChangeLogEntry(this.secondZip.toString());
        try {
            ZipEntry e;
            while ((e = zip.getNextEntry()) != null) {
                if (e.isDirectory()) continue;
                changeLog.addFile(new ExtractChangeLogParser.FileInZip(e.getName()));
            }
        }
        finally {
            zip.close();
        }
        this.saveToChangeLog(changeLogFile, changeLog);
        return true;
    }

    public ChangeLogParser createChangeLogParser() {
        return new ExtractChangeLogParser();
    }

    public static String escapeForXml(String string) {
        if (string == null) {
            return "";
        }
        int size = string.length();
        char ch = '\u0000';
        StringBuffer escapedString = new StringBuffer(size);
        block7: for (int index = 0; index < size; ++index) {
            ch = string.charAt(index);
            switch (ch) {
                case '&': {
                    escapedString.append("&amp;");
                    continue block7;
                }
                case '<': {
                    escapedString.append("&lt;");
                    continue block7;
                }
                case '>': {
                    escapedString.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    escapedString.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    escapedString.append("&quot;");
                    continue block7;
                }
                default: {
                    escapedString.append(ch);
                }
            }
        }
        return escapedString.toString().trim();
    }

    public void saveToChangeLog(File changeLogFile, ExtractChangeLogParser.ExtractChangeLogEntry changeLog) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(changeLogFile);
        PrintStream stream = new PrintStream((OutputStream)outputStream, false, "UTF-8");
        stream.println("<?xml version='1.0' encoding='UTF-8'?>");
        stream.println("<extractChanges>");
        stream.println("<entry>");
        stream.println("<zipFile>" + ExtractResourceWithChangesSCM.escapeForXml(changeLog.getZipFile()) + "</zipFile>");
        stream.println("<file>");
        for (String fileName : changeLog.getAffectedPaths()) {
            stream.println("<fileName>" + ExtractResourceWithChangesSCM.escapeForXml(fileName) + "</fileName>");
        }
        stream.println("</file>");
        stream.println("</entry>");
        stream.println("</extractChanges>");
        stream.close();
    }
}

