/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import hudson.Extension;
import hudson.ExtensionFinder;
import hudson.model.Hudson;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.java.sezpoz.Index;
import net.java.sezpoz.IndexItem;
import org.jvnet.hudson.test.TestEnvironment;
import org.jvnet.hudson.test.TestExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class TestExtensionLoader
extends ExtensionFinder {
    private static final Logger LOGGER = Logger.getLogger(TestExtensionLoader.class.getName());

    public <T> Collection<T> findExtensions(Class<T> type, Hudson hudson) {
        TestEnvironment env = TestEnvironment.get();
        ArrayList<T> result = new ArrayList<T>();
        ClassLoader cl = hudson.getPluginManager().uberClassLoader;
        for (IndexItem item : Index.load(TestExtension.class, Object.class, (ClassLoader)cl)) {
            try {
                Object instance;
                String testName;
                Class<?> extType;
                AnnotatedElement e = item.element();
                if (e instanceof Class) {
                    extType = (Class<?>)e;
                    if (!this.isActive(env, extType)) {
                        continue;
                    }
                } else if (e instanceof Field) {
                    Field f = (Field)e;
                    if (!f.getDeclaringClass().isInstance((Object)env.testCase)) continue;
                    extType = f.getType();
                } else if (e instanceof Method) {
                    Method m = (Method)e;
                    if (!m.getDeclaringClass().isInstance((Object)env.testCase)) continue;
                    extType = m.getReturnType();
                } else {
                    throw new AssertionError();
                }
                if ((testName = ((TestExtension)item.annotation()).value()).length() > 0 && !env.testCase.getName().equals(testName) || !type.isAssignableFrom(extType) || (instance = item.instance()) == null) continue;
                result.add(type.cast(instance));
            }
            catch (InstantiationException e) {
                LOGGER.log(Level.WARNING, "Failed to load " + item.className(), e);
            }
        }
        return result;
    }

    private boolean isActive(TestEnvironment env, Class<?> extType) {
        for (Class<?> outer = extType; outer != null; outer = outer.getEnclosingClass()) {
            if (!outer.isInstance((Object)env.testCase)) continue;
            return true;
        }
        return false;
    }
}

