/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import com.gargoylesoftware.htmlunit.AjaxController;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.DefaultCssErrorHandler;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.PageCreator;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitContextFactory;
import com.gargoylesoftware.htmlunit.javascript.host.xml.XMLHttpRequest;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import hudson.CloseProofOutputStream;
import hudson.DescriptorExtensionList;
import hudson.EnvVars;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.Functions;
import hudson.Launcher;
import hudson.Util;
import hudson.WebAppMain;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixProject;
import hudson.matrix.MatrixRun;
import hudson.maven.MavenEmbedder;
import hudson.maven.MavenModuleSet;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Computer;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.DownloadService;
import hudson.model.Executor;
import hudson.model.FreeStyleProject;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.JDK;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.RootAction;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.UpdateSite;
import hudson.model.View;
import hudson.remoting.Which;
import hudson.security.AbstractPasswordBasedSecurityRealm;
import hudson.security.GroupDetails;
import hudson.security.SecurityRealm;
import hudson.security.csrf.CrumbIssuer;
import hudson.slaves.CommandLauncher;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.ComputerListener;
import hudson.slaves.DumbSlave;
import hudson.slaves.RetentionStrategy;
import hudson.tasks.Ant;
import hudson.tasks.Mailer;
import hudson.tasks.Maven;
import hudson.tools.ToolProperty;
import hudson.util.PersistedList;
import hudson.util.StreamTaskListener;
import hudson.util.jna.GNUCLibrary;
import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.jar.Manifest;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ContextFactory;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.debug.Debugger;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.userdetails.User;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.jvnet.hudson.test.ClosureExecuterAction;
import org.jvnet.hudson.test.FakeLauncher;
import org.jvnet.hudson.test.HudsonHomeLoader;
import org.jvnet.hudson.test.HudsonPageCreator;
import org.jvnet.hudson.test.JavaNetReverseProxy;
import org.jvnet.hudson.test.LenientRunnable;
import org.jvnet.hudson.test.NoListenerConfiguration;
import org.jvnet.hudson.test.PretendSlave;
import org.jvnet.hudson.test.TestCrumbIssuer;
import org.jvnet.hudson.test.TestEnvironment;
import org.jvnet.hudson.test.WarExploder;
import org.jvnet.hudson.test.recipes.Recipe;
import org.jvnet.hudson.test.rhino.JavaScriptDebugger;
import org.kohsuke.stapler.Dispatcher;
import org.kohsuke.stapler.MetaClass;
import org.kohsuke.stapler.MetaClassLoader;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerResponse;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.MimeTypes;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.security.HashUserRealm;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.jetty.webapp.Configuration;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.jetty.webapp.WebXmlConfiguration;
import org.mozilla.javascript.tools.debugger.Dim;
import org.mozilla.javascript.tools.debugger.Main;
import org.mozilla.javascript.tools.shell.Global;
import org.springframework.dao.DataAccessException;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.ErrorHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HudsonTestCase
extends TestCase
implements RootAction {
    public Hudson hudson;
    protected final TestEnvironment env = new TestEnvironment(this);
    protected HudsonHomeLoader homeLoader = HudsonHomeLoader.NEW;
    protected int localPort;
    protected Server server;
    protected String contextPath = "";
    protected List<LenientRunnable> tearDowns = new ArrayList<LenientRunnable>();
    protected List<Recipe.Runner> recipes = new ArrayList<Recipe.Runner>();
    private List<WeakReference<WebClient>> clients = new ArrayList<WeakReference<WebClient>>();
    protected JavaScriptDebugger jsDebugger = new JavaScriptDebugger();
    private static final Logger XML_HTTP_REQUEST_LOGGER = Logger.getLogger(XMLHttpRequest.class.getName());
    private static final Logger LOGGER;
    protected static final List<ToolProperty<?>> NO_PROPERTIES;
    public static int SLAVE_DEBUG_PORT;
    public static final MimeTypes MIME_TYPES;

    protected HudsonTestCase(String name) {
        super(name);
    }

    protected HudsonTestCase() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runBare() throws Throwable {
        Thread t = Thread.currentThread();
        String o = ((Object)((Object)this)).getClass().getName() + '.' + t.getName();
        t.setName("Executing " + this.getName());
        try {
            super.runBare();
        }
        finally {
            t.setName(o);
        }
    }

    protected void setUp() throws Exception {
        this.env.pin();
        this.recipe();
        AbstractProject.WORKSPACE.toString();
        hudson.model.User.clear();
        try {
            this.hudson = this.newHudson();
        }
        catch (Exception e) {
            Field f = Hudson.class.getDeclaredField("theInstance");
            f.setAccessible(true);
            f.set(null, null);
            throw e;
        }
        this.hudson.setNoUsageStatistics(Boolean.valueOf(true));
        this.hudson.setCrumbIssuer((CrumbIssuer)new TestCrumbIssuer());
        this.hudson.servletContext.setAttribute("app", (Object)this.hudson);
        this.hudson.servletContext.setAttribute("version", (Object)"?");
        WebAppMain.installExpressionFactory((ServletContextEvent)new ServletContextEvent(this.hudson.servletContext));
        this.hudson.getJDKs().add(new JDK("default", System.getProperty("java.home")));
        this.configureUpdateCenter();
        this.hudson.getActions().add(this);
        Mailer.descriptor().setHudsonUrl(null);
        for (Descriptor d : this.hudson.getExtensionList(Descriptor.class)) {
            d.load();
        }
    }

    protected void configureUpdateCenter() throws Exception {
        String updateCenterUrl = "http://localhost:" + JavaNetReverseProxy.getInstance().localPort + "/update-center.json";
        DownloadService.neverUpdate = true;
        UpdateSite.neverUpdate = true;
        PersistedList sites = this.hudson.getUpdateCenter().getSites();
        sites.clear();
        sites.add((Object)new UpdateSite("default", updateCenterUrl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDown() throws Exception {
        try {
            for (WeakReference<WebClient> client : this.clients) {
                WebClient c = (WebClient)((Object)client.get());
                if (c == null) continue;
                c.getPage("about:blank");
            }
            this.clients.clear();
        }
        catch (Throwable throwable) {
            this.server.stop();
            for (LenientRunnable r : this.tearDowns) {
                r.run();
            }
            this.hudson.cleanUp();
            this.env.dispose();
            ExtensionList.clearLegacyInstances();
            DescriptorExtensionList.clearLegacyInstances();
            System.gc();
            throw throwable;
        }
        this.server.stop();
        for (LenientRunnable r : this.tearDowns) {
            r.run();
        }
        this.hudson.cleanUp();
        this.env.dispose();
        ExtensionList.clearLegacyInstances();
        DescriptorExtensionList.clearLegacyInstances();
        System.gc();
    }

    protected void runTest() throws Throwable {
        System.out.println("=== Starting " + ((Object)((Object)this)).getClass().getSimpleName() + "." + this.getName());
        super.runTest();
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "self";
    }

    protected Hudson newHudson() throws Exception {
        File home = this.homeLoader.allocate();
        for (Recipe.Runner r : this.recipes) {
            r.decorateHome(this, home);
        }
        return new Hudson(home, this.createWebServer());
    }

    protected ServletContext createWebServer() throws Exception {
        this.server = new Server();
        WebAppContext context = new WebAppContext(WarExploder.getExplodedDir().getPath(), this.contextPath);
        context.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        context.setConfigurations(new Configuration[]{new WebXmlConfiguration(), new NoListenerConfiguration()});
        this.server.setHandler((Handler)context);
        context.setMimeTypes(MIME_TYPES);
        SocketConnector connector = new SocketConnector();
        this.server.addConnector((Connector)connector);
        this.server.addUserRealm(this.configureUserRealm());
        this.server.start();
        this.localPort = connector.getLocalPort();
        return context.getServletContext();
    }

    protected UserRealm configureUserRealm() {
        HashUserRealm realm = new HashUserRealm();
        realm.setName("default");
        realm.put((Object)"alice", (Object)"alice");
        realm.put((Object)"bob", (Object)"bob");
        realm.put((Object)"charlie", (Object)"charlie");
        realm.addUserToRole("alice", "female");
        realm.addUserToRole("bob", "male");
        realm.addUserToRole("charlie", "male");
        return realm;
    }

    protected Maven.MavenInstallation configureDefaultMaven() throws Exception {
        return this.configureDefaultMaven("maven-2.0.7", 0);
    }

    protected Maven.MavenInstallation configureDefaultMaven(String mavenVersion, int mavenReqVersion) throws Exception {
        Maven.MavenInstallation mavenInstallation;
        String home = System.getProperty("maven.home");
        if (home != null && (mavenInstallation = new Maven.MavenInstallation("default", home, NO_PROPERTIES)).meetsMavenReqVersion((Launcher)this.createLocalLauncher(), mavenReqVersion)) {
            ((Maven.DescriptorImpl)this.hudson.getDescriptorByType(Maven.DescriptorImpl.class)).setInstallations(new Maven.MavenInstallation[]{mavenInstallation});
            return mavenInstallation;
        }
        LOGGER.warning("Extracting a copy of Maven bundled in the test harness. To avoid a performance hit, set the system property 'maven.home' to point to a Maven2 installation.");
        FilePath mvn = this.hudson.getRootPath().createTempFile("maven", "zip");
        mvn.copyFrom(HudsonTestCase.class.getClassLoader().getResource(mavenVersion + "-bin.zip"));
        File mvnHome = this.createTmpDir();
        mvn.unzip(new FilePath(mvnHome));
        if (!Functions.isWindows()) {
            GNUCLibrary.LIBC.chmod(new File(mvnHome, mavenVersion + "/bin/mvn").getPath(), 493);
        }
        Maven.MavenInstallation mavenInstallation2 = new Maven.MavenInstallation("default", new File(mvnHome, mavenVersion).getAbsolutePath(), NO_PROPERTIES);
        ((Maven.DescriptorImpl)this.hudson.getDescriptorByType(Maven.DescriptorImpl.class)).setInstallations(new Maven.MavenInstallation[]{mavenInstallation2});
        return mavenInstallation2;
    }

    protected Ant.AntInstallation configureDefaultAnt() throws Exception {
        Ant.AntInstallation antInstallation;
        if (System.getenv("ANT_HOME") != null) {
            antInstallation = new Ant.AntInstallation("default", System.getenv("ANT_HOME"), NO_PROPERTIES);
        } else {
            LOGGER.warning("Extracting a copy of Ant bundled in the test harness. To avoid a performance hit, set the environment variable ANT_HOME to point to an  Ant installation.");
            FilePath ant = this.hudson.getRootPath().createTempFile("ant", "zip");
            ant.copyFrom(HudsonTestCase.class.getClassLoader().getResource("apache-ant-1.7.1-bin.zip"));
            File antHome = this.createTmpDir();
            ant.unzip(new FilePath(antHome));
            if (!Functions.isWindows()) {
                GNUCLibrary.LIBC.chmod(new File(antHome, "apache-ant-1.7.1/bin/ant").getPath(), 493);
            }
            antInstallation = new Ant.AntInstallation("default", new File(antHome, "apache-ant-1.7.1").getAbsolutePath(), NO_PROPERTIES);
        }
        ((Ant.DescriptorImpl)this.hudson.getDescriptorByType(Ant.DescriptorImpl.class)).setInstallations(new Ant.AntInstallation[]{antInstallation});
        return antInstallation;
    }

    protected FreeStyleProject createFreeStyleProject() throws IOException {
        return this.createFreeStyleProject(this.createUniqueProjectName());
    }

    protected FreeStyleProject createFreeStyleProject(String name) throws IOException {
        return (FreeStyleProject)this.hudson.createProject(FreeStyleProject.class, name);
    }

    protected MatrixProject createMatrixProject() throws IOException {
        return this.createMatrixProject(this.createUniqueProjectName());
    }

    protected MatrixProject createMatrixProject(String name) throws IOException {
        return (MatrixProject)this.hudson.createProject(MatrixProject.class, name);
    }

    protected MavenModuleSet createMavenProject() throws IOException {
        return this.createMavenProject(this.createUniqueProjectName());
    }

    protected MavenModuleSet createMavenProject(String name) throws IOException {
        return (MavenModuleSet)this.hudson.createProject(MavenModuleSet.class, name);
    }

    private String createUniqueProjectName() {
        return "test" + this.hudson.getItems().size();
    }

    protected Launcher.LocalLauncher createLocalLauncher() {
        return new Launcher.LocalLauncher((TaskListener)new StreamTaskListener(System.out));
    }

    public File createTmpDir() throws IOException {
        return this.env.temporaryDirectoryAllocator.allocate();
    }

    public DumbSlave createSlave() throws Exception {
        return this.createSlave(null);
    }

    public DumbSlave createSlave(Label l) throws Exception {
        return this.createSlave(l, null);
    }

    public SecurityRealm createDummySecurityRealm() {
        return new AbstractPasswordBasedSecurityRealm(){

            protected UserDetails authenticate(String username, String password) throws AuthenticationException {
                if (username.equals(password)) {
                    return this.loadUserByUsername(username);
                }
                throw new BadCredentialsException(username);
            }

            public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
                return new User(username, "", true, true, true, true, new GrantedAuthority[]{AUTHENTICATED_AUTHORITY});
            }

            public GroupDetails loadGroupByGroupname(String groupname) throws UsernameNotFoundException, DataAccessException {
                throw new UsernameNotFoundException(groupname);
            }
        };
    }

    public URL getURL() throws IOException {
        return new URL("http://localhost:" + this.localPort + this.contextPath + "/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DumbSlave createSlave(Label l, EnvVars env) throws Exception {
        Hudson hudson = this.hudson;
        synchronized (hudson) {
            int sz = this.hudson.getNodes().size();
            DumbSlave slave = new DumbSlave("slave" + sz, "dummy", this.createTmpDir().getPath(), "1", Node.Mode.NORMAL, l == null ? "" : l.getName(), (ComputerLauncher)this.createComputerLauncher(env), RetentionStrategy.NOOP, Collections.EMPTY_LIST);
            this.hudson.addNode((Node)slave);
            return slave;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PretendSlave createPretendSlave(FakeLauncher faker) throws Exception {
        Hudson hudson = this.hudson;
        synchronized (hudson) {
            int sz = this.hudson.getNodes().size();
            PretendSlave slave = new PretendSlave("slave" + sz, this.createTmpDir().getPath(), "", (ComputerLauncher)this.createComputerLauncher(null), faker);
            this.hudson.addNode((Node)slave);
            return slave;
        }
    }

    public CommandLauncher createComputerLauncher(EnvVars env) throws URISyntaxException, MalformedURLException {
        int sz = this.hudson.getNodes().size();
        return new CommandLauncher(String.format("\"%s/bin/java\" %s -jar \"%s\"", System.getProperty("java.home"), SLAVE_DEBUG_PORT > 0 ? " -Xdebug -Xrunjdwp:transport=dt_socket,server=y,address=" + (SLAVE_DEBUG_PORT + sz) : "", new File(this.hudson.getJnlpJars("slave.jar").getURL().toURI()).getAbsolutePath()), env);
    }

    public DumbSlave createOnlineSlave() throws Exception {
        return this.createOnlineSlave(null);
    }

    public DumbSlave createOnlineSlave(Label l) throws Exception {
        return this.createOnlineSlave(l, null);
    }

    public DumbSlave createOnlineSlave(Label l, EnvVars env) throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        ComputerListener waiter = new ComputerListener(){

            public void onOnline(Computer C, TaskListener t) {
                latch.countDown();
                this.unregister();
            }
        };
        waiter.register();
        DumbSlave s = this.createSlave(l, env);
        latch.await();
        return s;
    }

    public void interactiveBreak() throws Exception {
        System.out.println("Hudson is running at http://localhost:" + this.localPort + "/");
        new BufferedReader(new InputStreamReader(System.in)).readLine();
    }

    protected <T> T last(List<T> items) {
        return items.get(items.size() - 1);
    }

    protected void pause() throws IOException {
        new BufferedReader(new InputStreamReader(System.in)).readLine();
    }

    protected Page search(String q) throws Exception {
        return new WebClient().search(q);
    }

    public <R extends Run> R assertBuildStatus(Result status, R r) throws Exception {
        if (status == r.getResult()) {
            return r;
        }
        String msg = "unexpected build status; build log was:\n------\n" + HudsonTestCase.getLog(r) + "\n------\n";
        if (r instanceof MatrixBuild) {
            MatrixBuild mb = (MatrixBuild)r;
            for (MatrixRun mr : mb.getRuns()) {
                msg = msg + "--- " + mr.getParent().getCombination() + " ---\n" + HudsonTestCase.getLog((Run)mr) + "\n------\n";
            }
        }
        HudsonTestCase.assertEquals((String)msg, (Object)status, (Object)r.getResult());
        return r;
    }

    public boolean isGoodHttpStatus(int status) {
        if (400 <= status && status <= 417) {
            return false;
        }
        return 500 > status || status > 505;
    }

    public void assertGoodStatus(Page page) {
        HudsonTestCase.assertTrue((boolean)this.isGoodHttpStatus(page.getWebResponse().getStatusCode()));
    }

    public <R extends Run> R assertBuildStatusSuccess(R r) throws Exception {
        this.assertBuildStatus(Result.SUCCESS, r);
        return r;
    }

    public <R extends Run> R assertBuildStatusSuccess(Future<? extends R> r) throws Exception {
        return (R)this.assertBuildStatusSuccess((Run)r.get());
    }

    public <J extends AbstractProject<J, R>, R extends AbstractBuild<J, R>> R buildAndAssertSuccess(J job) throws Exception {
        return (R)((AbstractBuild)this.assertBuildStatusSuccess(job.scheduleBuild2(0)));
    }

    public void assertLogContains(String substring, Run run) throws Exception {
        String log = HudsonTestCase.getLog(run);
        if (log.contains(substring)) {
            return;
        }
        System.out.println(log);
        HudsonTestCase.fail((String)("Console output of " + run + " didn't contain " + substring));
    }

    protected static String getLog(Run run) throws IOException {
        return Util.loadFile((File)run.getLogFile(), (Charset)run.getCharset());
    }

    public void assertXPath(HtmlPage page, String xpath) {
        HudsonTestCase.assertNotNull((String)("There should be an object that matches XPath:" + xpath), (Object)page.getDocumentElement().selectSingleNode(xpath));
    }

    public void assertXPath(DomNode page, String xpath) {
        List nodes = page.getByXPath(xpath);
        HudsonTestCase.assertFalse((String)("There should be an object that matches XPath:" + xpath), (boolean)nodes.isEmpty());
    }

    public void assertXPathValue(DomNode page, String xpath, String expectedValue) {
        Object node = page.getFirstByXPath(xpath);
        HudsonTestCase.assertNotNull((String)"no node found", (Object)node);
        HudsonTestCase.assertTrue((String)("the found object was not a Node " + xpath), (boolean)(node instanceof org.w3c.dom.Node));
        org.w3c.dom.Node n = (org.w3c.dom.Node)node;
        String textString = n.getTextContent();
        HudsonTestCase.assertEquals((String)("xpath value should match for " + xpath), (String)expectedValue, (String)textString);
    }

    public void assertXPathValueContains(DomNode page, String xpath, String needle) {
        Object node = page.getFirstByXPath(xpath);
        HudsonTestCase.assertNotNull((String)"no node found", (Object)node);
        HudsonTestCase.assertTrue((String)("the found object was not a Node " + xpath), (boolean)(node instanceof org.w3c.dom.Node));
        org.w3c.dom.Node n = (org.w3c.dom.Node)node;
        String textString = n.getTextContent();
        HudsonTestCase.assertTrue((String)"needle found in haystack", (boolean)textString.contains(needle));
    }

    public void assertXPathResultsContainText(DomNode page, String xpath, String needle) {
        List nodes = page.getByXPath(xpath);
        HudsonTestCase.assertFalse((String)"no nodes matching xpath found", (boolean)nodes.isEmpty());
        boolean found = false;
        for (Object o : nodes) {
            org.w3c.dom.Node n;
            String textString;
            if (!(o instanceof org.w3c.dom.Node) || (textString = (n = (org.w3c.dom.Node)o).getTextContent()) == null || !textString.contains(needle)) continue;
            found = true;
            break;
        }
        HudsonTestCase.assertTrue((String)"needle found in haystack", (boolean)found);
    }

    public void assertStringContains(String message, String haystack, String needle) {
        if (haystack.contains(needle)) {
            return;
        }
        HudsonTestCase.fail((String)(message + " (seeking '" + needle + "')"));
    }

    public void assertStringContains(String haystack, String needle) {
        if (haystack.contains(needle)) {
            return;
        }
        HudsonTestCase.fail((String)("Could not find '" + needle + "'."));
    }

    public void assertHelpExists(final Class<? extends Describable> type, final String properties) throws Exception {
        this.executeOnServer(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Descriptor d = HudsonTestCase.this.hudson.getDescriptor(type);
                WebClient wc = HudsonTestCase.this.createWebClient();
                for (String property : properties.split(",")) {
                    String url = d.getHelpFile(property);
                    Assert.assertNotNull((String)("Help file for the property " + property + " is missing on " + type), (Object)url);
                    wc.goTo(url);
                }
                return null;
            }
        });
    }

    public HtmlPage submit(HtmlForm form) throws Exception {
        return (HtmlPage)form.submit((SubmittableElement)((HtmlButton)this.last(form.getHtmlElementsByTagName("button"))));
    }

    public HtmlPage submit(HtmlForm form, String name) throws Exception {
        for (HtmlElement e : form.getHtmlElementsByTagName("button")) {
            HtmlElement p = (HtmlElement)e.getParentNode().getParentNode();
            if (!p.getAttribute("name").equals(name)) continue;
            ((HtmlButton)e).click();
            return (HtmlPage)form.submit((SubmittableElement)((HtmlButton)e));
        }
        throw new AssertionError((Object)("No such submit button with the name " + name));
    }

    protected HtmlInput findPreviousInputElement(HtmlElement current, String name) {
        return (HtmlInput)current.selectSingleNode("(preceding::input[@name='_." + name + "'])[last()]");
    }

    protected HtmlButton getButtonByCaption(HtmlForm f, String s) {
        for (HtmlElement b : f.getHtmlElementsByTagName("button")) {
            if (!b.getTextContent().trim().equals(s)) continue;
            return (HtmlButton)b;
        }
        return null;
    }

    public TaskListener createTaskListener() {
        return new StreamTaskListener((OutputStream)new CloseProofOutputStream((OutputStream)System.out));
    }

    public void assertEqualBeans(Object lhs, Object rhs, String properties) throws Exception {
        HudsonTestCase.assertNotNull((String)"lhs is null", (Object)lhs);
        HudsonTestCase.assertNotNull((String)"rhs is null", (Object)rhs);
        for (String p : properties.split(",")) {
            Object rp;
            Object lp;
            PropertyDescriptor pd = PropertyUtils.getPropertyDescriptor((Object)lhs, (String)p);
            if (pd == null) {
                try {
                    Field f = lhs.getClass().getField(p);
                    lp = f.get(lhs);
                    rp = f.get(rhs);
                }
                catch (NoSuchFieldException e) {
                    HudsonTestCase.assertNotNull((String)("No such property " + p + " on " + lhs.getClass()), (Object)pd);
                    return;
                }
            } else {
                lp = PropertyUtils.getProperty((Object)lhs, (String)p);
                rp = PropertyUtils.getProperty((Object)rhs, (String)p);
            }
            HudsonTestCase.assertEquals((String)("Property " + p + " is different"), (Object)lp, (Object)rp);
        }
    }

    protected <T extends Descriptor<?>> T get(Class<T> d) {
        return (T)this.hudson.getDescriptorByType(d);
    }

    protected boolean isSomethingHappening() {
        if (!this.hudson.getQueue().isEmpty()) {
            return true;
        }
        for (Computer n : this.hudson.getComputers()) {
            if (n.isIdle()) continue;
            return true;
        }
        return false;
    }

    protected void waitUntilNoActivity() throws Exception {
        this.waitUntilNoActivityUpTo(60000);
    }

    protected void waitUntilNoActivityUpTo(int timeout) throws Exception {
        long startTime = System.currentTimeMillis();
        int streak = 0;
        do {
            Thread.sleep(100L);
            streak = this.isSomethingHappening() ? 0 : ++streak;
            if (streak <= 5) continue;
            return;
        } while (System.currentTimeMillis() - startTime <= (long)timeout);
        ArrayList<Queue.Executable> building = new ArrayList<Queue.Executable>();
        for (Computer c : this.hudson.getComputers()) {
            for (Executor e : c.getExecutors()) {
                if (!e.isBusy()) continue;
                building.add(e.getCurrentExecutable());
            }
        }
        throw new AssertionError((Object)String.format("Hudson is still doing something after %dms: queue=%s building=%s", timeout, Arrays.asList(this.hudson.getQueue().getItems()), building));
    }

    protected void recipe() throws Exception {
        this.recipeLoadCurrentPlugin();
        try {
            Method runMethod = ((Object)((Object)this)).getClass().getMethod(this.getName(), new Class[0]);
            for (final Annotation a : runMethod.getAnnotations()) {
                Recipe r = a.annotationType().getAnnotation(Recipe.class);
                if (r == null) continue;
                final Recipe.Runner runner = r.value().newInstance();
                this.recipes.add(runner);
                this.tearDowns.add(new LenientRunnable(){

                    public void run() throws Exception {
                        runner.tearDown(HudsonTestCase.this, a);
                    }
                });
                runner.setup(this, a);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    protected void recipeLoadCurrentPlugin() throws Exception {
        Enumeration<URL> e = ((Object)((Object)this)).getClass().getClassLoader().getResources("the.hpl");
        if (!e.hasMoreElements()) {
            return;
        }
        final URL hpl = e.nextElement();
        if (e.hasMoreElements()) {
            URL hpl2 = e.nextElement();
            throw new Error("We have both " + hpl + " and " + hpl2);
        }
        this.recipes.add(new Recipe.Runner(){

            public void decorateHome(HudsonTestCase testCase, File home) throws Exception {
                Manifest m = new Manifest(hpl.openStream());
                String shortName = m.getMainAttributes().getValue("Short-Name");
                if (shortName == null) {
                    throw new Error(hpl + " doesn't have the Short-Name attribute");
                }
                FileUtils.copyURLToFile((URL)hpl, (File)new File(home, "plugins/" + shortName + ".hpl"));
                String dependencies = m.getMainAttributes().getValue("Plugin-Dependencies");
                if (dependencies != null) {
                    MavenEmbedder embedder = new MavenEmbedder(null);
                    embedder.setClassLoader(this.getClass().getClassLoader());
                    embedder.start();
                    for (String dep : dependencies.split(",")) {
                        String[] tokens = dep.split(":");
                        String artifactId = tokens[0];
                        String version = tokens[1];
                        File dependencyJar = null;
                        AbstractArtifactResolutionException resolutionError = null;
                        for (String groupId : new String[]{"org.jvnet.hudson.plugins", "org.jvnet.hudson.main"}) {
                            URL dependencyPomResource = this.getClass().getResource("/META-INF/maven/" + groupId + "/" + artifactId + "/pom.xml");
                            if (dependencyPomResource != null) {
                                dependencyJar = Which.jarFile((URL)dependencyPomResource);
                                break;
                            }
                            Artifact a = embedder.createArtifact(groupId, artifactId, version, "compile", "hpi");
                            try {
                                embedder.resolve(a, Arrays.asList(embedder.createRepository("http://maven.glassfish.org/content/groups/public/", "repo")), embedder.getLocalRepository());
                                dependencyJar = a.getFile();
                            }
                            catch (AbstractArtifactResolutionException x) {
                                resolutionError = x;
                            }
                        }
                        if (dependencyJar == null) {
                            throw new Exception("Failed to resolve plugin: " + dep, resolutionError);
                        }
                        File dst = new File(home, "plugins/" + artifactId + ".hpi");
                        if (dst.exists() && dst.lastModified() == dependencyJar.lastModified()) continue;
                        FileUtils.copyFile(dependencyJar, (File)dst);
                    }
                    embedder.stop();
                }
            }
        });
    }

    public HudsonTestCase withNewHome() {
        return this.with(HudsonHomeLoader.NEW);
    }

    public HudsonTestCase withExistingHome(File source) throws Exception {
        return this.with(new HudsonHomeLoader.CopyExisting(source));
    }

    public HudsonTestCase withPresetData(String name) {
        name = "/" + name + ".zip";
        URL res = ((Object)((Object)this)).getClass().getResource(name);
        if (res == null) {
            throw new IllegalArgumentException("No such data set found: " + name);
        }
        return this.with(new HudsonHomeLoader.CopyExisting(res));
    }

    public HudsonTestCase with(HudsonHomeLoader homeLoader) {
        this.homeLoader = homeLoader;
        return this;
    }

    public <V> V executeOnServer(final Callable<V> c) throws Exception {
        final Exception[] t = new Exception[1];
        final ArrayList r = new ArrayList(1);
        ClosureExecuterAction cea = (ClosureExecuterAction)this.hudson.getExtensionList(RootAction.class).get(ClosureExecuterAction.class);
        UUID id = UUID.randomUUID();
        cea.add(id, new Runnable(){

            public void run() {
                try {
                    StaplerResponse rsp = Stapler.getCurrentResponse();
                    rsp.setStatus(200);
                    rsp.setContentType("text/html");
                    r.add(c.call());
                }
                catch (Exception e) {
                    t[0] = e;
                }
            }
        });
        this.createWebClient().goTo("closures/?uuid=" + id);
        if (t[0] != null) {
            throw t[0];
        }
        return (V)r.get(0);
    }

    private Object writeReplace() {
        throw new AssertionError((Object)("HudsonTestCase " + this.getName() + " is not supposed to be serialized"));
    }

    public WebClient createWebClient() {
        return new WebClient();
    }

    static {
        Locale.setDefault(Locale.ENGLISH);
        Dispatcher.TRACE = true;
        MetaClass.NO_CACHE = true;
        File dir = new File("src/main/resources");
        if (dir.exists() && MetaClassLoader.debugLoader == null) {
            try {
                MetaClassLoader.debugLoader = new MetaClassLoader((ClassLoader)new URLClassLoader(new URL[]{dir.toURI().toURL()}));
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
        }
        Logger.getLogger("org.springframework").setLevel(Level.WARNING);
        hudson.Main.isUnitTest = true;
        XML_HTTP_REQUEST_LOGGER.setFilter(new Filter(){

            public boolean isLoggable(LogRecord record) {
                return !record.getMessage().contains("XMLHttpRequest.getResponseHeader() was called before the response was available.");
            }
        });
        System.setProperty("org.mortbay.jetty.Request.maxFormContentSize", "-1");
        LOGGER = Logger.getLogger(HudsonTestCase.class.getName());
        NO_PROPERTIES = Collections.emptyList();
        SLAVE_DEBUG_PORT = Integer.getInteger(HudsonTestCase.class.getName() + ".slaveDebugPort", -1);
        MIME_TYPES = new MimeTypes();
        MIME_TYPES.addMimeMapping("js", "application/javascript");
        Functions.DEBUG_YUI = true;
    }

    public class WebClient
    extends com.gargoylesoftware.htmlunit.WebClient {
        public WebClient() {
            super(BrowserVersion.FIREFOX_2);
            this.setPageCreator((PageCreator)HudsonPageCreator.INSTANCE);
            HudsonTestCase.this.clients.add(new WeakReference<WebClient>(this));
            this.setAjaxController(new AjaxController(){

                public boolean processSynchron(HtmlPage page, WebRequestSettings settings, boolean async) {
                    return false;
                }
            });
            this.setCssErrorHandler(new ErrorHandler(){
                final ErrorHandler defaultHandler = new DefaultCssErrorHandler();

                public void warning(CSSParseException exception) throws CSSException {
                    if (!this.ignore(exception)) {
                        this.defaultHandler.warning(exception);
                    }
                }

                public void error(CSSParseException exception) throws CSSException {
                    if (!this.ignore(exception)) {
                        this.defaultHandler.error(exception);
                    }
                }

                public void fatalError(CSSParseException exception) throws CSSException {
                    if (!this.ignore(exception)) {
                        this.defaultHandler.fatalError(exception);
                    }
                }

                private boolean ignore(CSSParseException e) {
                    return e.getURI().contains("/yui/");
                }
            });
            this.getJavaScriptEngine().getContextFactory().addListener(new ContextFactory.Listener(){

                public void contextCreated(Context cx) {
                    if (cx.getDebugger() == null) {
                        cx.setDebugger((Debugger)HudsonTestCase.this.jsDebugger, null);
                    }
                }

                public void contextReleased(Context cx) {
                }
            });
        }

        public WebClient login(String username, String password) throws Exception {
            HtmlPage page = this.goTo("/login");
            HtmlForm form = page.getFormByName("login");
            form.getInputByName("j_username").setValueAttribute(username);
            form.getInputByName("j_password").setValueAttribute(password);
            form.submit(null);
            return this;
        }

        public WebClient login(String username) throws Exception {
            this.login(username, username);
            return this;
        }

        public HtmlPage search(String q) throws IOException, SAXException {
            HtmlPage top = this.goTo("");
            HtmlForm search = top.getFormByName("search");
            search.getInputByName("q").setValueAttribute(q);
            return (HtmlPage)search.submit(null);
        }

        public HtmlPage getPage(Run r) throws IOException, SAXException {
            return this.getPage(r, "");
        }

        public HtmlPage getPage(Run r, String relative) throws IOException, SAXException {
            return this.goTo(r.getUrl() + relative);
        }

        public HtmlPage getPage(Item item) throws IOException, SAXException {
            return this.getPage(item, "");
        }

        public HtmlPage getPage(Item item, String relative) throws IOException, SAXException {
            return this.goTo(item.getUrl() + relative);
        }

        public HtmlPage getPage(Node item) throws IOException, SAXException {
            return this.getPage(item, "");
        }

        public HtmlPage getPage(Node item, String relative) throws IOException, SAXException {
            return this.goTo(item.toComputer().getUrl() + relative);
        }

        public HtmlPage getPage(View view) throws IOException, SAXException {
            return this.goTo(view.getUrl());
        }

        public HtmlPage getPage(View view, String relative) throws IOException, SAXException {
            return this.goTo(view.getUrl() + relative);
        }

        public Page getPage(String url) throws IOException, FailingHttpStatusCodeException {
            return super.getPage(url);
        }

        public HtmlPage goTo(String relative) throws IOException, SAXException {
            Page p = this.goTo(relative, "text/html");
            if (p instanceof HtmlPage) {
                return (HtmlPage)p;
            }
            throw new AssertionError((Object)("Expected text/html but instead the content type was " + p.getWebResponse().getContentType()));
        }

        public Page goTo(String relative, String expectedContentType) throws IOException, SAXException {
            Page p = super.getPage(this.getContextPath() + relative);
            Assert.assertEquals((String)expectedContentType, (String)p.getWebResponse().getContentType());
            return p;
        }

        public XmlPage goToXml(String path) throws IOException, SAXException {
            Page page = this.goTo(path, "application/xml");
            if (page instanceof XmlPage) {
                return (XmlPage)page;
            }
            return null;
        }

        public String getContextPath() throws IOException {
            return HudsonTestCase.this.getURL().toExternalForm();
        }

        public WebRequestSettings addCrumb(WebRequestSettings req) {
            NameValuePair[] crumb = new NameValuePair[]{new NameValuePair()};
            crumb[0].setName(HudsonTestCase.this.hudson.getCrumbIssuer().getDescriptor().getCrumbRequestField());
            crumb[0].setValue(HudsonTestCase.this.hudson.getCrumbIssuer().getCrumb(null));
            req.setRequestParameters(Arrays.asList(crumb));
            return req;
        }

        public URL createCrumbedUrl(String relativePath) throws IOException {
            CrumbIssuer issuer = HudsonTestCase.this.hudson.getCrumbIssuer();
            String crumbName = issuer.getDescriptor().getCrumbRequestField();
            String crumb = issuer.getCrumb(null);
            return new URL(this.getContextPath() + relativePath + "?" + crumbName + "=" + crumb);
        }

        public HtmlPage eval(Runnable requestHandler) throws IOException, SAXException {
            ClosureExecuterAction cea = (ClosureExecuterAction)HudsonTestCase.this.hudson.getExtensionList(RootAction.class).get(ClosureExecuterAction.class);
            UUID id = UUID.randomUUID();
            cea.add(id, requestHandler);
            return this.goTo("closures/?uuid=" + id);
        }

        public Dim interactiveJavaScriptDebugger() {
            Global global = new Global();
            HtmlUnitContextFactory cf = this.getJavaScriptEngine().getContextFactory();
            global.init((ContextFactory)cf);
            Dim dim = Main.mainEmbedded((ContextFactory)cf, (Scriptable)global, (String)("Rhino debugger: " + HudsonTestCase.this.getName()));
            dim.setBreakOnExceptions(true);
            return dim;
        }
    }
}

