/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import hudson.PluginManager;
import hudson.PluginWrapper;
import hudson.Util;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hudson.test.WarExploder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestPluginManager
extends PluginManager {
    public static final PluginManager INSTANCE;
    private static final Logger LOGGER;

    private TestPluginManager() throws IOException {
        super(null, Util.createTempDir());
    }

    protected Collection<String> loadBundledPlugins() throws Exception {
        File[] children;
        HashSet<String> names = new HashSet<String>();
        for (File child : children = new File(WarExploder.getExplodedDir(), "WEB-INF/plugins").listFiles()) {
            try {
                names.add(child.getName());
                this.copyBundledPlugin(child.toURI().toURL(), child.getName());
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Failed to extract the bundled plugin " + child, e);
            }
        }
        return names;
    }

    public void stop() {
        for (PluginWrapper p : this.activePlugins) {
            p.stop();
        }
    }

    static {
        LOGGER = Logger.getLogger(TestPluginManager.class.getName());
        try {
            INSTANCE = new TestPluginManager();
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }
}

