/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.utils.marshal;

import com.thoughtworks.xstream.XStream;
import org.hudsonci.utils.id.OID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XUtil {
    private static final Logger log = LoggerFactory.getLogger(XUtil.class);
    private static final XStream xstream = new XStream();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object clone(Object source) {
        if (source == null) {
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace("Cloning: {}", (Object)OID.get(source));
        }
        xstream.autodetectAnnotations(true);
        String xml = xstream.toXML(source);
        log.trace("Clone XML: {}", (Object)xml);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(source.getClass().getClassLoader());
        try {
            Object target = xstream.fromXML(xml);
            if (log.isTraceEnabled()) {
                log.trace("Clone: {}", (Object)OID.get(target));
            }
            Object object = target;
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public static String render(Object source) {
        if (source == null) {
            return null;
        }
        xstream.autodetectAnnotations(true);
        String xml = xstream.toXML(source);
        log.trace("Rendered XML: {}", (Object)xml);
        return xml;
    }
}

