/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven.agent;

import hudson.maven.agent.AbortException;
import hudson.maven.agent.ComponentConfiguratorFilter;
import hudson.maven.agent.ContainerFilter;
import hudson.maven.agent.PluginManagerListener;
import java.io.IOException;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.DefaultPluginManager;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.PluginConfigurationException;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ComponentConfigurator;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.PlexusConfiguration;

public class PluginManagerInterceptor
extends DefaultPluginManager {
    private static PluginManagerListener listener;
    private ComponentConfiguratorFilter configuratorFilter;

    public static void setListener(PluginManagerListener _listener) {
        listener = _listener;
    }

    public void initialize() {
        super.initialize();
        this.container = new ContainerFilter(this.container){

            public PlexusContainer getChildContainer(String name) {
                PlexusContainer child = super.getChildContainer(name);
                if (child == null) {
                    return null;
                }
                return new ContainerFilter(child){

                    public Object lookup(String componentKey) throws ComponentLookupException {
                        return this.wrap(super.lookup(componentKey), componentKey);
                    }

                    public Object lookup(String role, String roleHint) throws ComponentLookupException {
                        return this.wrap(super.lookup(role, roleHint), role);
                    }

                    public void release(Object component) throws ComponentLifecycleException {
                        if (component == PluginManagerInterceptor.this.configuratorFilter) {
                            super.release(((PluginManagerInterceptor)PluginManagerInterceptor.this).configuratorFilter.core);
                        } else {
                            super.release(component);
                        }
                    }

                    private Object wrap(Object c, String componentKey) {
                        if (c != null && componentKey.equals(ComponentConfigurator.ROLE)) {
                            if (((PluginManagerInterceptor)PluginManagerInterceptor.this).configuratorFilter.core != null) {
                                throw new IllegalStateException("ComponentConfigurationFilter being reused. This is a bug in Hudson. Please report that to the development team.");
                            }
                            ((PluginManagerInterceptor)PluginManagerInterceptor.this).configuratorFilter.core = (ComponentConfigurator)c;
                            c = PluginManagerInterceptor.this.configuratorFilter;
                        }
                        return c;
                    }
                };
            }
        };
    }

    public void executeMojo(final MavenProject project, final MojoExecution mojoExecution, MavenSession session) throws ArtifactResolutionException, MojoExecutionException, MojoFailureException, ArtifactNotFoundException, InvalidDependencyVersionException, PluginManagerException, PluginConfigurationException {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MojoConfig {
            PlexusConfiguration config;
            ExpressionEvaluator eval;

            MojoConfig() {
            }

            void callPost(Exception exception) throws IOException, InterruptedException {
                if (listener != null) {
                    listener.postExecute(project, mojoExecution, this.config, this.eval, exception);
                }
            }
        }
        final MojoConfig config = new MojoConfig();
        this.configuratorFilter = new ComponentConfiguratorFilter(null){
            {
                super(x0);
            }

            public void configureComponent(Object component, PlexusConfiguration configuration, ExpressionEvaluator expressionEvaluator, ClassRealm containerRealm, ConfigurationListener configListener) throws ComponentConfigurationException {
                try {
                    config.config = configuration;
                    config.eval = expressionEvaluator;
                    if (listener != null) {
                        listener.preExecute(project, mojoExecution, configuration, expressionEvaluator);
                    }
                    super.configureComponent(component, configuration, expressionEvaluator, containerRealm, configListener);
                }
                catch (IOException e) {
                    throw new ComponentConfigurationException((Throwable)e);
                }
                catch (InterruptedException e) {
                    throw new AbortException("Execution aborted", e);
                }
            }
        };
        try {
            try {
                super.executeMojo(project, mojoExecution, session);
                config.callPost(null);
            }
            catch (MojoExecutionException e) {
                config.callPost((Exception)((Object)e));
                throw e;
            }
            catch (MojoFailureException e) {
                config.callPost((Exception)((Object)e));
                throw e;
            }
        }
        catch (InterruptedException e) {
            throw new AbortException("Execution aborted", e);
        }
        catch (IOException e) {
            throw new PluginManagerException(e.getMessage(), (Exception)e);
        }
    }
}

