/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven.agent;

import hudson.maven.agent.AbortException;
import hudson.maven.agent.ComponentConfiguratorFilter;
import hudson.maven.agent.ComponentInterceptor;
import hudson.maven.agent.ContainerFilter;
import hudson.maven.agent.PluginManagerListener;
import java.io.IOException;
import java.lang.reflect.Method;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.DefaultPluginManager;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.PluginConfigurationException;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ComponentConfigurator;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.PlexusConfiguration;

public class PluginManagerInterceptor
extends DefaultPluginManager {
    private static PluginManagerListener listener;
    private ComponentConfiguratorFilter configuratorFilter;

    public static void setListener(PluginManagerListener _listener) {
        listener = _listener;
    }

    public void initialize() {
        super.initialize();
        this.container = new ContainerFilter(this.container){

            public PlexusContainer getChildContainer(String name) {
                PlexusContainer child = super.getChildContainer(name);
                if (child == null) {
                    return null;
                }
                return new ContainerFilter(child){

                    public Object lookup(String componentKey) throws ComponentLookupException {
                        return this.wrap(super.lookup(componentKey), componentKey);
                    }

                    public Object lookup(String role, String roleHint) throws ComponentLookupException {
                        return this.wrap(super.lookup(role, roleHint), role);
                    }

                    public void release(Object component) throws ComponentLifecycleException {
                        if (component == PluginManagerInterceptor.this.configuratorFilter) {
                            super.release(((PluginManagerInterceptor)PluginManagerInterceptor.this).configuratorFilter.core);
                        } else {
                            super.release(component);
                        }
                    }

                    private Object wrap(Object c, String componentKey) {
                        if (PluginManagerInterceptor.this.configuratorFilter == null) {
                            return c;
                        }
                        if (c != null && componentKey.equals(ComponentConfigurator.ROLE)) {
                            if (((PluginManagerInterceptor)PluginManagerInterceptor.this).configuratorFilter.core != null) {
                                throw new IllegalStateException("ComponentConfigurationFilter being reused. This is a bug in Hudson. Please report that to the development team.");
                            }
                            ((PluginManagerInterceptor)PluginManagerInterceptor.this).configuratorFilter.core = (ComponentConfigurator)c;
                            c = PluginManagerInterceptor.this.configuratorFilter;
                        }
                        return c;
                    }
                };
            }
        };
    }

    public void executeMojo(final MavenProject project, final MojoExecution mojoExecution, MavenSession session) throws ArtifactResolutionException, MojoExecutionException, MojoFailureException, ArtifactNotFoundException, InvalidDependencyVersionException, PluginManagerException, PluginConfigurationException {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MojoIntercepterImpl
        extends MojoIntercepter {
            MojoIntercepterImpl() {
            }

            @Override
            protected void pre(Object component, PlexusConfiguration configuration, ExpressionEvaluator expressionEvaluator) throws IOException, InterruptedException {
                if (listener != null) {
                    listener.preExecute(project, mojoExecution, (Mojo)component, configuration, expressionEvaluator);
                }
            }

            void callPost(Exception exception) throws IOException, InterruptedException {
                if (listener != null) {
                    listener.postExecute(project, mojoExecution, this.mojo, this.config, this.eval, exception);
                }
            }
        }
        MojoIntercepterImpl interceptor = new MojoIntercepterImpl();
        try {
            try {
                super.executeMojo(project, mojoExecution, session);
                interceptor.callPost(null);
            }
            catch (MojoExecutionException e) {
                interceptor.callPost((Exception)((Object)e));
                throw e;
            }
            catch (MojoFailureException e) {
                interceptor.callPost((Exception)((Object)e));
                throw e;
            }
        }
        catch (InterruptedException e) {
            throw new AbortException("Execution aborted", e);
        }
        catch (IOException e) {
            throw new PluginManagerException(e.getMessage(), (Exception)e);
        }
        finally {
            this.configuratorFilter = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenReport getReport(MavenProject project, final MojoExecution mojoExecution, MavenSession session) throws ArtifactNotFoundException, PluginConfigurationException, PluginManagerException, ArtifactResolutionException {
        MavenReport r;
        final MojoIntercepter interceptor = new MojoIntercepter(){

            protected void pre(Object component, PlexusConfiguration configuration, ExpressionEvaluator expressionEvaluator) throws IOException, InterruptedException {
            }
        };
        try {
            r = super.getReport(project, mojoExecution, session);
        }
        finally {
            this.configuratorFilter = null;
        }
        if (r == null) {
            return null;
        }
        r = new ComponentInterceptor<MavenReport>(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("generate")) {
                    Object r = super.invoke(proxy, method, args);
                    try {
                        listener.onReportGenerated((MavenReport)this.delegate, mojoExecution, interceptor.config, interceptor.eval);
                    }
                    catch (InterruptedException e) {
                        throw new AbortException("Execution aborted", e);
                    }
                    catch (IOException e) {
                        throw new MavenReportException(e.getMessage(), (Exception)e);
                    }
                    return r;
                }
                return super.invoke(proxy, method, args);
            }
        }.wrap(r);
        return r;
    }

    private abstract class MojoIntercepter
    extends ComponentConfiguratorFilter {
        PlexusConfiguration config;
        ExpressionEvaluator eval;
        Mojo mojo;

        MojoIntercepter() {
            super(null);
            PluginManagerInterceptor.this.configuratorFilter = this;
        }

        public void configureComponent(Object component, PlexusConfiguration configuration, ExpressionEvaluator expressionEvaluator, ClassRealm containerRealm, ConfigurationListener configListener) throws ComponentConfigurationException {
            try {
                this.config = configuration;
                this.eval = expressionEvaluator;
                this.mojo = (Mojo)component;
                this.pre(component, configuration, expressionEvaluator);
                super.configureComponent(component, configuration, expressionEvaluator, containerRealm, configListener);
            }
            catch (IOException e) {
                throw new ComponentConfigurationException((Throwable)e);
            }
            catch (InterruptedException e) {
                throw new AbortException("Execution aborted", e);
            }
        }

        protected abstract void pre(Object var1, PlexusConfiguration var2, ExpressionEvaluator var3) throws IOException, InterruptedException;
    }
}

