/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.maven3.agent;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.codehaus.plexus.classworlds.launcher.Launcher;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.jvnet.hudson.maven3.agent.RealFilterOutputStream;

public class Maven3Main {
    private static Launcher launcher;

    public static void main(String[] args) throws Exception {
        Maven3Main.main(new File(args[0]), new File(args[1]), new File(args[2]), Integer.parseInt(args[3]));
    }

    public static void main(File m2Home, File remotingJar, File interceptorJar, int tcpPort) throws Exception {
        try {
            m2Home = m2Home.getCanonicalFile();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (!m2Home.exists()) {
            System.err.println("No such directory exists: " + m2Home);
            System.exit(1);
        }
        Maven3Main.versionCheck();
        System.setProperty("maven.home", m2Home.getPath());
        if (interceptorJar != null) {
            System.setProperty("maven3.interceptor", interceptorJar.getPath());
        }
        launcher = new Launcher();
        launcher.setSystemClassLoader(Maven3Main.class.getClassLoader());
        launcher.configure(Maven3Main.class.getResourceAsStream("classworlds.conf"));
        ClassRealm remoting = launcher.getWorld().newRealm("hudson-remoting", launcher.getSystemClassLoader());
        remoting.setParentRealm(launcher.getWorld().getRealm("plexus.core"));
        remoting.addURL(remotingJar.toURI().toURL());
        final Socket s = new Socket((String)null, tcpPort);
        Class remotingLauncher = remoting.loadClass("hudson.remoting.Launcher");
        remotingLauncher.getMethod("main", InputStream.class, OutputStream.class).invoke(null, new BufferedInputStream(new FilterInputStream(s.getInputStream()){

            public void close() throws IOException {
                s.shutdownInput();
            }
        }), new BufferedOutputStream(new RealFilterOutputStream(s.getOutputStream()){

            public void close() throws IOException {
                s.shutdownOutput();
            }
        }));
        System.exit(0);
    }

    public static int launch(String[] args) throws Exception {
        try {
            launcher.launch(args);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new Exception(e);
        }
        return launcher.getExitCode();
    }

    private static void versionCheck() {
        String v = System.getProperty("java.class.version");
        if (v != null) {
            try {
                if ((double)Float.parseFloat(v) < 49.0) {
                    System.err.println("Native maven support requires Java 1.5 or later, but this Maven is using " + System.getProperty("java.home"));
                    System.err.println("Please use the freestyle project.");
                    System.exit(1);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

