/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.eventspy_30;

import com.google.common.base.Preconditions;
import org.apache.maven.eventspy.internal.EventSpyDispatcher;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.lifecycle.internal.LifecycleDebugLogger;
import org.apache.maven.lifecycle.internal.ProjectBuildList;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.hudsonci.utils.common.TestAccessible;

@Component(role=LifecycleDebugLogger.class)
public class LifecycleDebugLoggerImpl
extends LifecycleDebugLogger {
    @Requirement
    private EventSpyDispatcher dispatcher;

    public LifecycleDebugLoggerImpl() {
    }

    @TestAccessible
    public LifecycleDebugLoggerImpl(Logger logger) {
        super(logger);
    }

    public void debugReactorPlan(ProjectBuildList projectBuilds) {
        this.dispatcher.onEvent((Object)new ReactorPlanEvent(projectBuilds));
    }

    public void debugProjectPlan(MavenProject currentProject, MavenExecutionPlan executionPlan) {
        this.dispatcher.onEvent((Object)new ProjectPlanEvent(currentProject, executionPlan));
    }

    public void logWeavePlan(MavenSession session) {
        this.dispatcher.onEvent((Object)new WeavePlanEvent(session));
    }

    public class WeavePlanEvent {
        public final MavenSession session;

        public WeavePlanEvent(MavenSession session) {
            this.session = (MavenSession)Preconditions.checkNotNull((Object)session);
        }

        public void delegate() {
            LifecycleDebugLoggerImpl.super.logWeavePlan(this.session);
        }

        public String toString() {
            return "WeavePlanEvent{session=" + this.session + '}';
        }
    }

    public class ProjectPlanEvent {
        public final MavenProject currentProject;
        public final MavenExecutionPlan executionPlan;

        public ProjectPlanEvent(MavenProject currentProject, MavenExecutionPlan executionPlan) {
            this.currentProject = (MavenProject)Preconditions.checkNotNull((Object)currentProject);
            this.executionPlan = (MavenExecutionPlan)Preconditions.checkNotNull((Object)executionPlan);
        }

        public void delegate() {
            LifecycleDebugLoggerImpl.super.debugProjectPlan(this.currentProject, this.executionPlan);
        }

        public String toString() {
            return "ProjectPlanEvent{currentProject=" + this.currentProject + ", executionPlan=" + this.executionPlan + '}';
        }
    }

    public class ReactorPlanEvent {
        public final ProjectBuildList projectBuilds;

        public ReactorPlanEvent(ProjectBuildList projectBuilds) {
            this.projectBuilds = (ProjectBuildList)Preconditions.checkNotNull((Object)projectBuilds);
        }

        public void delegate() {
            LifecycleDebugLoggerImpl.super.debugReactorPlan(this.projectBuilds);
        }

        public String toString() {
            return "ReactorPlanEvent{projectBuilds=" + this.projectBuilds + '}';
        }
    }
}

