/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.eventspy_30;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Profile;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.hudsonci.maven.eventspy_30.ResolvedProfile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileCollector {
    private final MavenProject initiatingProject;
    private final Collection<String> activeProfiles;
    private final Collection<ResolvedProfile> container;

    private ProfileCollector(MavenProject project) {
        this.initiatingProject = project;
        this.activeProfiles = this.getActiveProfileIds(project.getInjectedProfileIds());
        this.container = new ArrayList<ResolvedProfile>();
    }

    public static Collection<ResolvedProfile> collect(MavenProject project) {
        Preconditions.checkNotNull((Object)project);
        return new ProfileCollector(project).execute();
    }

    private Collection<ResolvedProfile> execute() {
        this.collectExternal();
        this.collectFromProjectUp(this.initiatingProject);
        return this.container;
    }

    private void collectExternal() {
        ProjectBuildingRequest projectBuildingRequest = this.initiatingProject.getProjectBuildingRequest();
        if (null != projectBuildingRequest) {
            this.collectResolvedProfiles(ResolvedProfile.EXTERNAL, projectBuildingRequest.getProfiles());
        }
    }

    private void collectFromProjectUp(MavenProject project) {
        if (null == project) {
            return;
        }
        this.collectResolvedProfiles(project, project.getModel().getProfiles());
        this.collectFromProjectUp(project.getParent());
    }

    private void collectResolvedProfiles(MavenProject source, Collection<Profile> profiles) {
        for (Profile profile : profiles) {
            this.container.add(new ResolvedProfile(source, profile, this.isActive(profile)));
        }
    }

    private boolean isActive(Profile profile) {
        return this.activeProfiles.contains(profile.getId());
    }

    private Collection<String> getActiveProfileIds(Map<String, List<String>> activeProfilesMap) {
        ArrayList<String> allActiveProfiles = new ArrayList<String>();
        Collection<List<String>> values = activeProfilesMap.values();
        for (List<String> list : values) {
            allActiveProfiles.addAll(list);
        }
        return allActiveProfiles;
    }
}

