/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.eventspy_30.handler;

import java.util.List;
import java.util.Set;
import javax.inject.Named;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.BuildSummary;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.hudsonci.maven.eventspy_30.EventSpyHandler;
import org.hudsonci.maven.eventspy_30.handler.ProfileLogger;
import org.hudsonci.maven.eventspy_30.handler.ProjectLogger;
import org.hudsonci.maven.model.MavenCoordinatesDTO;
import org.hudsonci.maven.model.state.ArtifactDTO;
import org.hudsonci.maven.model.state.MavenProjectDTO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
public class ExecutionEventHandler
extends EventSpyHandler<ExecutionEvent> {
    public void handle(ExecutionEvent event) throws Exception {
        ExecutionEvent.Type type = event.getType();
        this.log.debug("Execution event type: {}", (Object)type);
        this.recordSessionStarted(event);
        this.recordProjectStarted(event);
        this.recordMojoStarted(event);
        this.recordProjectFinished(event);
    }

    private void recordSessionStarted(ExecutionEvent event) {
        if (ExecutionEvent.Type.SessionStarted.equals((Object)event.getType())) {
            List projects = event.getSession().getProjects();
            this.log.debug("Recording MavenProjects");
            this.getBuildRecorder().recordSessionStarted(projects);
            ProfileLogger.log(event);
        }
    }

    private void recordProjectStarted(ExecutionEvent event) {
        if (ExecutionEvent.Type.ProjectStarted.equals((Object)event.getType())) {
            MavenProject project = event.getProject();
            this.log.debug("Updating MavenProject");
            this.getBuildRecorder().recordProjectStarted(project);
            ProjectLogger.log(project, "project started");
        }
    }

    private void recordProjectFinished(ExecutionEvent event) {
        ExecutionEvent.Type type = event.getType();
        if (ExecutionEvent.Type.ProjectSucceeded.equals((Object)type) || ExecutionEvent.Type.ProjectFailed.equals((Object)type) || ExecutionEvent.Type.ProjectSkipped.equals((Object)type)) {
            MavenProject project = event.getProject();
            BuildSummary buildSummary = event.getSession().getResult().getBuildSummary(project);
            this.log.debug("Updating MavenProject");
            this.getBuildRecorder().recordProjectFinished(project, buildSummary);
            ProjectLogger.log(project, "project finished");
        }
    }

    private void recordMojoStarted(ExecutionEvent event) {
        if (ExecutionEvent.Type.MojoStarted.equals((Object)event.getType())) {
            MojoExecution mojoExecution = event.getMojoExecution();
            ProjectLogger.log(event.getProject(), "mojo started - " + mojoExecution.getLifecyclePhase() + " " + mojoExecution.getArtifactId() + " " + mojoExecution.getExecutionId());
        }
    }

    private void recordDirectArtifacts(MavenProject project, MavenProjectDTO projectDTO) {
        Set artifacts = project.getDependencyArtifacts();
        for (Artifact artifact : artifacts) {
            ArtifactDTO artifactDTO = new ArtifactDTO().withCoordinates(new MavenCoordinatesDTO().withGroupId(artifact.getGroupId()).withArtifactId(artifact.getArtifactId()).withType(artifact.getType()).withVersion(artifact.getVersion()).withClassifier(artifact.getClassifier()).normalize());
            artifactDTO.getDependentProjects().add(projectDTO.getId());
        }
    }
}

