/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.eventspy_30;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import org.apache.maven.BuildAbort;
import org.apache.maven.eventspy.EventSpy;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.hudsonci.maven.eventspy_30.EventSpySupport;
import org.hudsonci.maven.eventspy_30.RemotingEventSpy;
import org.hudsonci.utils.common.TestAccessible;
import org.sonatype.guice.bean.binders.SpaceModule;
import org.sonatype.guice.bean.binders.WireModule;
import org.sonatype.guice.bean.locators.MutableBeanLocator;
import org.sonatype.guice.bean.reflect.ClassSpace;
import org.sonatype.guice.bean.reflect.URLClassSpace;
import org.sonatype.inject.BeanEntry;

@Component(role=EventSpy.class, hint="delegating")
public class DelegatingEventSpy
extends EventSpySupport
implements Module {
    @Requirement
    private MutableBeanLocator locator;
    private EventSpy delegate;

    public DelegatingEventSpy() {
    }

    @TestAccessible
    public DelegatingEventSpy(EventSpy delegate) {
        this.delegate = (EventSpy)Preconditions.checkNotNull((Object)delegate);
    }

    public EventSpy getDelegate() {
        Preconditions.checkState((this.delegate != null ? 1 : 0) != 0);
        return this.delegate;
    }

    public void configure(Binder binder) {
        binder.bind(MutableBeanLocator.class).toInstance((Object)this.locator);
    }

    public void init(EventSpy.Context context) throws Exception {
        try {
            this.log.debug("Initializing w/context: {}", (Object)context);
            Preconditions.checkNotNull((Object)context);
            super.init(context);
            if (this.log.isTraceEnabled()) {
                this.log.trace("Context keys: {}", context.getData().keySet());
                this.log.trace("Container: {}", (Object)this.getContainer());
                this.log.trace("Working dir: {}", (Object)this.getWorkingDirectory());
                this.log.trace("Version properties:");
                for (Map.Entry<Object, Object> entry : this.getVersionProperties().entrySet()) {
                    this.log.trace("  {}='{}'", entry.getKey(), entry.getValue());
                }
                this.log.trace("User properties:");
                for (Map.Entry<Object, Object> entry : this.getUserProperties().entrySet()) {
                    this.log.trace("  {}='{}'", entry.getKey(), entry.getValue());
                }
                this.log.trace("System properties:");
                for (Map.Entry<Object, Object> entry : this.getSystemProperties().entrySet()) {
                    this.log.trace("  {}='{}'", entry.getKey(), entry.getValue());
                }
            }
            if (this.delegate == null) {
                this.delegate = this.loadDelegate();
                this.log.debug("Delegate: {}", (Object)this.delegate);
            }
            this.getDelegate().init(context);
        }
        catch (Throwable e) {
            this.log.error("Init failed", e);
            if (e instanceof BuildAbort) {
                throw (BuildAbort)e;
            }
            throw new BuildAbort("Failed to initialize", e);
        }
    }

    private EventSpy loadDelegate() {
        Preconditions.checkState((this.locator != null ? 1 : 0) != 0);
        URL[] scanPath = new URL[]{((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation()};
        URLClassSpace space = new URLClassSpace(((Object)((Object)this)).getClass().getClassLoader(), scanPath);
        Injector injector = Guice.createInjector((Module[])new Module[]{new WireModule(new Module[]{new SpaceModule((ClassSpace)space), this})});
        if (this.log.isDebugEnabled()) {
            this.log.debug("Known spies:");
            for (BeanEntry spy : this.locator.locate(Key.get(EventSpy.class))) {
                this.log.debug("  {}", (Object)spy);
            }
        }
        String name = this.getProperty("hudson.eventspy.delegate", RemotingEventSpy.class.getName());
        this.log.debug("Loading delegate named: {}", (Object)name);
        Iterator itr = this.locator.locate(Key.get(EventSpy.class, (Annotation)Names.named((String)name))).iterator();
        if (itr.hasNext()) {
            return (EventSpy)((BeanEntry)itr.next()).getValue();
        }
        throw new RuntimeException("No such delegate: " + name);
    }

    public void close() throws Exception {
        try {
            this.log.debug("Closing");
            this.ensureOpened();
            this.getDelegate().close();
        }
        catch (Throwable e) {
            this.log.error("Close failed", e);
            if (e instanceof BuildAbort) {
                throw (BuildAbort)e;
            }
            throw new BuildAbort("Failed to close", e);
        }
    }

    public void onEvent(Object event) throws Exception {
        try {
            this.ensureOpened();
            this.getDelegate().onEvent(event);
        }
        catch (Exception e) {
            this.log.error("Failed to handle event", (Throwable)e);
            throw e;
        }
    }
}

